/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a chained function invocation that has started execution, including start time and execution
 * context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChainedInvokeStartedDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ChainedInvokeStartedDetails.Builder, ChainedInvokeStartedDetails> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(ChainedInvokeStartedDetails::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(ChainedInvokeStartedDetails::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final SdkField<EventInput> INPUT_FIELD = SdkField.<EventInput> builder(MarshallingType.SDK_POJO)
            .memberName("Input").getter(getter(ChainedInvokeStartedDetails::input)).setter(setter(Builder::input))
            .constructor(EventInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<String> EXECUTED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutedVersion").getter(getter(ChainedInvokeStartedDetails::executedVersion))
            .setter(setter(Builder::executedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedVersion").build()).build();

    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionArn").getter(getter(ChainedInvokeStartedDetails::durableExecutionArn))
            .setter(setter(Builder::durableExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            TENANT_ID_FIELD, INPUT_FIELD, EXECUTED_VERSION_FIELD, DURABLE_EXECUTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String functionName;

    private final String tenantId;

    private final EventInput input;

    private final String executedVersion;

    private final String durableExecutionArn;

    private ChainedInvokeStartedDetails(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.tenantId = builder.tenantId;
        this.input = builder.input;
        this.executedVersion = builder.executedVersion;
        this.durableExecutionArn = builder.durableExecutionArn;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function being invoked.
     * </p>
     * 
     * @return The name or ARN of the Lambda function being invoked.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The tenant identifier for the chained invocation.
     * </p>
     * 
     * @return The tenant identifier for the chained invocation.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The JSON input payload provided to the chained invocation.
     * </p>
     * 
     * @return The JSON input payload provided to the chained invocation.
     */
    public final EventInput input() {
        return input;
    }

    /**
     * <p>
     * The version of the function that was executed.
     * </p>
     * 
     * @return The version of the function that was executed.
     */
    public final String executedVersion() {
        return executedVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the durable execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the durable execution.
     */
    public final String durableExecutionArn() {
        return durableExecutionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(executedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChainedInvokeStartedDetails)) {
            return false;
        }
        ChainedInvokeStartedDetails other = (ChainedInvokeStartedDetails) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(input(), other.input()) && Objects.equals(executedVersion(), other.executedVersion())
                && Objects.equals(durableExecutionArn(), other.durableExecutionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChainedInvokeStartedDetails").add("FunctionName", functionName()).add("TenantId", tenantId())
                .add("Input", input()).add("ExecutedVersion", executedVersion())
                .add("DurableExecutionArn", durableExecutionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "ExecutedVersion":
            return Optional.ofNullable(clazz.cast(executedVersion()));
        case "DurableExecutionArn":
            return Optional.ofNullable(clazz.cast(durableExecutionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("ExecutedVersion", EXECUTED_VERSION_FIELD);
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChainedInvokeStartedDetails, T> g) {
        return obj -> g.apply((ChainedInvokeStartedDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChainedInvokeStartedDetails> {
        /**
         * <p>
         * The name or ARN of the Lambda function being invoked.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function being invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The tenant identifier for the chained invocation.
         * </p>
         * 
         * @param tenantId
         *        The tenant identifier for the chained invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The JSON input payload provided to the chained invocation.
         * </p>
         * 
         * @param input
         *        The JSON input payload provided to the chained invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(EventInput input);

        /**
         * <p>
         * The JSON input payload provided to the chained invocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventInput.Builder} avoiding the need to
         * create one manually via {@link EventInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventInput.Builder#build()} is called immediately and its result
         * is passed to {@link #input(EventInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link EventInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(EventInput)
         */
        default Builder input(Consumer<EventInput.Builder> input) {
            return input(EventInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * The version of the function that was executed.
         * </p>
         * 
         * @param executedVersion
         *        The version of the function that was executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedVersion(String executedVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the durable execution.
         * </p>
         * 
         * @param durableExecutionArn
         *        The Amazon Resource Name (ARN) that identifies the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionArn(String durableExecutionArn);
    }

    static final class BuilderImpl implements Builder {
        private String functionName;

        private String tenantId;

        private EventInput input;

        private String executedVersion;

        private String durableExecutionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ChainedInvokeStartedDetails model) {
            functionName(model.functionName);
            tenantId(model.tenantId);
            input(model.input);
            executedVersion(model.executedVersion);
            durableExecutionArn(model.durableExecutionArn);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final EventInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(EventInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(EventInput input) {
            this.input = input;
            return this;
        }

        public final String getExecutedVersion() {
            return executedVersion;
        }

        public final void setExecutedVersion(String executedVersion) {
            this.executedVersion = executedVersion;
        }

        @Override
        public final Builder executedVersion(String executedVersion) {
            this.executedVersion = executedVersion;
            return this;
        }

        public final String getDurableExecutionArn() {
            return durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        @Override
        public ChainedInvokeStartedDetails build() {
            return new ChainedInvokeStartedDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
