/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the tenant isolation mode configuration for a Lambda function. This allows you to configure specific tenant
 * isolation strategies for your function invocations. Tenant isolation configuration cannot be modified after function
 * creation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TenancyConfig implements SdkPojo, Serializable, ToCopyableBuilder<TenancyConfig.Builder, TenancyConfig> {
    private static final SdkField<String> TENANT_ISOLATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantIsolationMode").getter(getter(TenancyConfig::tenantIsolationModeAsString))
            .setter(setter(Builder::tenantIsolationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantIsolationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ISOLATION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantIsolationMode;

    private TenancyConfig(BuilderImpl builder) {
        this.tenantIsolationMode = builder.tenantIsolationMode;
    }

    /**
     * <p>
     * Tenant isolation mode allows for invocation to be sent to a corresponding execution environment dedicated to a
     * specific tenant ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tenantIsolationMode} will return {@link TenantIsolationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tenantIsolationModeAsString}.
     * </p>
     * 
     * @return Tenant isolation mode allows for invocation to be sent to a corresponding execution environment dedicated
     *         to a specific tenant ID.
     * @see TenantIsolationMode
     */
    public final TenantIsolationMode tenantIsolationMode() {
        return TenantIsolationMode.fromValue(tenantIsolationMode);
    }

    /**
     * <p>
     * Tenant isolation mode allows for invocation to be sent to a corresponding execution environment dedicated to a
     * specific tenant ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tenantIsolationMode} will return {@link TenantIsolationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tenantIsolationModeAsString}.
     * </p>
     * 
     * @return Tenant isolation mode allows for invocation to be sent to a corresponding execution environment dedicated
     *         to a specific tenant ID.
     * @see TenantIsolationMode
     */
    public final String tenantIsolationModeAsString() {
        return tenantIsolationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantIsolationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TenancyConfig)) {
            return false;
        }
        TenancyConfig other = (TenancyConfig) obj;
        return Objects.equals(tenantIsolationModeAsString(), other.tenantIsolationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TenancyConfig").add("TenantIsolationMode", tenantIsolationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantIsolationMode":
            return Optional.ofNullable(clazz.cast(tenantIsolationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantIsolationMode", TENANT_ISOLATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TenancyConfig, T> g) {
        return obj -> g.apply((TenancyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TenancyConfig> {
        /**
         * <p>
         * Tenant isolation mode allows for invocation to be sent to a corresponding execution environment dedicated to
         * a specific tenant ID.
         * </p>
         * 
         * @param tenantIsolationMode
         *        Tenant isolation mode allows for invocation to be sent to a corresponding execution environment
         *        dedicated to a specific tenant ID.
         * @see TenantIsolationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TenantIsolationMode
         */
        Builder tenantIsolationMode(String tenantIsolationMode);

        /**
         * <p>
         * Tenant isolation mode allows for invocation to be sent to a corresponding execution environment dedicated to
         * a specific tenant ID.
         * </p>
         * 
         * @param tenantIsolationMode
         *        Tenant isolation mode allows for invocation to be sent to a corresponding execution environment
         *        dedicated to a specific tenant ID.
         * @see TenantIsolationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TenantIsolationMode
         */
        Builder tenantIsolationMode(TenantIsolationMode tenantIsolationMode);
    }

    static final class BuilderImpl implements Builder {
        private String tenantIsolationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TenancyConfig model) {
            tenantIsolationMode(model.tenantIsolationMode);
        }

        public final String getTenantIsolationMode() {
            return tenantIsolationMode;
        }

        public final void setTenantIsolationMode(String tenantIsolationMode) {
            this.tenantIsolationMode = tenantIsolationMode;
        }

        @Override
        public final Builder tenantIsolationMode(String tenantIsolationMode) {
            this.tenantIsolationMode = tenantIsolationMode;
            return this;
        }

        @Override
        public final Builder tenantIsolationMode(TenantIsolationMode tenantIsolationMode) {
            this.tenantIsolationMode(tenantIsolationMode == null ? null : tenantIsolationMode.toString());
            return this;
        }

        @Override
        public TenancyConfig build() {
            return new TenancyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
