/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFunctionConcurrencyRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, PutFunctionConcurrencyRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(PutFunctionConcurrencyRequest.getter(PutFunctionConcurrencyRequest::functionName)).setter(PutFunctionConcurrencyRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<Integer> RESERVED_CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReservedConcurrentExecutions").getter(PutFunctionConcurrencyRequest.getter(PutFunctionConcurrencyRequest::reservedConcurrentExecutions)).setter(PutFunctionConcurrencyRequest.setter(Builder::reservedConcurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedConcurrentExecutions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, RESERVED_CONCURRENT_EXECUTIONS_FIELD));
    private final String functionName;
    private final Integer reservedConcurrentExecutions;

    private PutFunctionConcurrencyRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.reservedConcurrentExecutions = builder.reservedConcurrentExecutions;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final Integer reservedConcurrentExecutions() {
        return this.reservedConcurrentExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedConcurrentExecutions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionConcurrencyRequest)) {
            return false;
        }
        PutFunctionConcurrencyRequest other = (PutFunctionConcurrencyRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.reservedConcurrentExecutions(), other.reservedConcurrentExecutions());
    }

    public final String toString() {
        return ToString.builder((String)"PutFunctionConcurrencyRequest").add("FunctionName", (Object)this.functionName()).add("ReservedConcurrentExecutions", (Object)this.reservedConcurrentExecutions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "ReservedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.reservedConcurrentExecutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionConcurrencyRequest, T> g) {
        return obj -> g.apply((PutFunctionConcurrencyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private Integer reservedConcurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionConcurrencyRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.reservedConcurrentExecutions(model.reservedConcurrentExecutions);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final Integer getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        public final void setReservedConcurrentExecutions(Integer reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
        }

        @Override
        public final Builder reservedConcurrentExecutions(Integer reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFunctionConcurrencyRequest build() {
            return new PutFunctionConcurrencyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutFunctionConcurrencyRequest> {
        public Builder functionName(String var1);

        public Builder reservedConcurrentExecutions(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

