/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionResponse extends LambdaResponse implements
        ToCopyableBuilder<GetFunctionResponse.Builder, GetFunctionResponse> {
    private static final SdkField<FunctionConfiguration> CONFIGURATION_FIELD = SdkField
            .<FunctionConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(GetFunctionResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(FunctionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<FunctionCodeLocation> CODE_FIELD = SdkField
            .<FunctionCodeLocation> builder(MarshallingType.SDK_POJO).memberName("Code")
            .getter(getter(GetFunctionResponse::code)).setter(setter(Builder::code)).constructor(FunctionCodeLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetFunctionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Concurrency> CONCURRENCY_FIELD = SdkField.<Concurrency> builder(MarshallingType.SDK_POJO)
            .memberName("Concurrency").getter(getter(GetFunctionResponse::concurrency)).setter(setter(Builder::concurrency))
            .constructor(Concurrency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Concurrency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            CODE_FIELD, TAGS_FIELD, CONCURRENCY_FIELD));

    private final FunctionConfiguration configuration;

    private final FunctionCodeLocation code;

    private final Map<String, String> tags;

    private final Concurrency concurrency;

    private GetFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.code = builder.code;
        this.tags = builder.tags;
        this.concurrency = builder.concurrency;
    }

    /**
     * <p>
     * The configuration of the function or version.
     * </p>
     * 
     * @return The configuration of the function or version.
     */
    public final FunctionConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The deployment package of the function or version.
     * </p>
     * 
     * @return The deployment package of the function or version.
     */
    public final FunctionCodeLocation code() {
        return code;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
     * concurrency</a>.
     * </p>
     * 
     * @return The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
     *         concurrency</a>.
     */
    public final Concurrency concurrency() {
        return concurrency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(concurrency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionResponse)) {
            return false;
        }
        GetFunctionResponse other = (GetFunctionResponse) obj;
        return Objects.equals(configuration(), other.configuration()) && Objects.equals(code(), other.code())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(concurrency(), other.concurrency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFunctionResponse").add("Configuration", configuration()).add("Code", code())
                .add("Tags", hasTags() ? tags() : null).add("Concurrency", concurrency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Concurrency":
            return Optional.ofNullable(clazz.cast(concurrency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionResponse, T> g) {
        return obj -> g.apply((GetFunctionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFunctionResponse> {
        /**
         * <p>
         * The configuration of the function or version.
         * </p>
         * 
         * @param configuration
         *        The configuration of the function or version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(FunctionConfiguration configuration);

        /**
         * <p>
         * The configuration of the function or version.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionConfiguration.Builder} avoiding
         * the need to create one manually via {@link FunctionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(FunctionConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link FunctionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(FunctionConfiguration)
         */
        default Builder configuration(Consumer<FunctionConfiguration.Builder> configuration) {
            return configuration(FunctionConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The deployment package of the function or version.
         * </p>
         * 
         * @param code
         *        The deployment package of the function or version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(FunctionCodeLocation code);

        /**
         * <p>
         * The deployment package of the function or version.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionCodeLocation.Builder} avoiding
         * the need to create one manually via {@link FunctionCodeLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionCodeLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #code(FunctionCodeLocation)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link FunctionCodeLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(FunctionCodeLocation)
         */
        default Builder code(Consumer<FunctionCodeLocation.Builder> code) {
            return code(FunctionCodeLocation.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.
         * </p>
         * 
         * @param tags
         *        The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
         * concurrency</a>.
         * </p>
         * 
         * @param concurrency
         *        The function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
         *        concurrency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrency(Concurrency concurrency);

        /**
         * <p>
         * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
         * concurrency</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Concurrency.Builder} avoiding the need to
         * create one manually via {@link Concurrency#builder()}.
         *
         * When the {@link Consumer} completes, {@link Concurrency.Builder#build()} is called immediately and its result
         * is passed to {@link #concurrency(Concurrency)}.
         * 
         * @param concurrency
         *        a consumer that will call methods on {@link Concurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #concurrency(Concurrency)
         */
        default Builder concurrency(Consumer<Concurrency.Builder> concurrency) {
            return concurrency(Concurrency.builder().applyMutation(concurrency).build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private FunctionConfiguration configuration;

        private FunctionCodeLocation code;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Concurrency concurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionResponse model) {
            super(model);
            configuration(model.configuration);
            code(model.code);
            tags(model.tags);
            concurrency(model.concurrency);
        }

        public final FunctionConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(FunctionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FunctionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final FunctionCodeLocation.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        public final void setCode(FunctionCodeLocation.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(FunctionCodeLocation code) {
            this.code = code;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Concurrency.Builder getConcurrency() {
            return concurrency != null ? concurrency.toBuilder() : null;
        }

        public final void setConcurrency(Concurrency.BuilderImpl concurrency) {
            this.concurrency = concurrency != null ? concurrency.build() : null;
        }

        @Override
        public final Builder concurrency(Concurrency concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @Override
        public GetFunctionResponse build() {
            return new GetFunctionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
