/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem;

public class ListProvisionedConcurrencyConfigsPublisher
implements SdkPublisher<ListProvisionedConcurrencyConfigsResponse> {
    private final LambdaAsyncClient client;
    private final ListProvisionedConcurrencyConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProvisionedConcurrencyConfigsPublisher(LambdaAsyncClient client, ListProvisionedConcurrencyConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProvisionedConcurrencyConfigsPublisher(LambdaAsyncClient client, ListProvisionedConcurrencyConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProvisionedConcurrencyConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProvisionedConcurrencyConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs() {
        Function<ListProvisionedConcurrencyConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedConcurrencyConfigs() != null) {
                return response.provisionedConcurrencyConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProvisionedConcurrencyConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProvisionedConcurrencyConfigsResponseFetcher
    implements AsyncPageFetcher<ListProvisionedConcurrencyConfigsResponse> {
        private ListProvisionedConcurrencyConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisionedConcurrencyConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListProvisionedConcurrencyConfigsResponse> nextPage(ListProvisionedConcurrencyConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListProvisionedConcurrencyConfigsPublisher.this.client.listProvisionedConcurrencyConfigs(ListProvisionedConcurrencyConfigsPublisher.this.firstRequest);
            }
            return ListProvisionedConcurrencyConfigsPublisher.this.client.listProvisionedConcurrencyConfigs((ListProvisionedConcurrencyConfigsRequest)((Object)ListProvisionedConcurrencyConfigsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

