/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageConfig> {
    private static final SdkField<List<String>> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntryPoint").getter(ImageConfig.getter(ImageConfig::entryPoint)).setter(ImageConfig.setter(Builder::entryPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryPoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Command").getter(ImageConfig.getter(ImageConfig::command)).setter(ImageConfig.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkingDirectory").getter(ImageConfig.getter(ImageConfig::workingDirectory)).setter(ImageConfig.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_FIELD, COMMAND_FIELD, WORKING_DIRECTORY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> entryPoint;
    private final List<String> command;
    private final String workingDirectory;

    private ImageConfig(BuilderImpl builder) {
        this.entryPoint = builder.entryPoint;
        this.command = builder.command;
        this.workingDirectory = builder.workingDirectory;
    }

    public final boolean hasEntryPoint() {
        return this.entryPoint != null && !(this.entryPoint instanceof SdkAutoConstructList);
    }

    public final List<String> entryPoint() {
        return this.entryPoint;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntryPoint() ? this.entryPoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfig)) {
            return false;
        }
        ImageConfig other = (ImageConfig)obj;
        return this.hasEntryPoint() == other.hasEntryPoint() && Objects.equals(this.entryPoint(), other.entryPoint()) && this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && Objects.equals(this.workingDirectory(), other.workingDirectory());
    }

    public final String toString() {
        return ToString.builder((String)"ImageConfig").add("EntryPoint", this.hasEntryPoint() ? this.entryPoint() : null).add("Command", this.hasCommand() ? this.command() : null).add("WorkingDirectory", (Object)this.workingDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "WorkingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageConfig, T> g) {
        return obj -> g.apply((ImageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> entryPoint = DefaultSdkAutoConstructList.getInstance();
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private String workingDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfig model) {
            this.entryPoint(model.entryPoint);
            this.command(model.command);
            this.workingDirectory(model.workingDirectory);
        }

        public final Collection<String> getEntryPoint() {
            if (this.entryPoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entryPoint;
        }

        @Override
        public final Builder entryPoint(Collection<String> entryPoint) {
            this.entryPoint = StringListCopier.copy(entryPoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryPoint(String ... entryPoint) {
            this.entryPoint(Arrays.asList(entryPoint));
            return this;
        }

        public final void setEntryPoint(Collection<String> entryPoint) {
            this.entryPoint = StringListCopier.copy(entryPoint);
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public ImageConfig build() {
            return new ImageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageConfig> {
        public Builder entryPoint(Collection<String> var1);

        public Builder entryPoint(String ... var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder workingDirectory(String var1);
    }
}

