/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.AccountUsage;

@SdkInternalApi
public class AccountUsageMarshaller {
    private static final MarshallingInfo<Long> TOTALCODESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCodeSize").build();
    private static final MarshallingInfo<Long> FUNCTIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionCount").build();
    private static final AccountUsageMarshaller INSTANCE = new AccountUsageMarshaller();

    public static AccountUsageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AccountUsage accountUsage, ProtocolMarshaller protocolMarshaller) {
        if (accountUsage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)accountUsage.totalCodeSize(), TOTALCODESIZE_BINDING);
            protocolMarshaller.marshall((Object)accountUsage.functionCount(), FUNCTIONCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

