/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.FunctionCodeLocation;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFunctionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetFunctionResponse> {
    private final FunctionConfiguration configuration;
    private final FunctionCodeLocation code;
    private final Map<String, String> tags;

    private GetFunctionResponse(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.code = builder.code;
        this.tags = builder.tags;
    }

    public FunctionConfiguration configuration() {
        return this.configuration;
    }

    public FunctionCodeLocation code() {
        return this.code;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionResponse)) {
            return false;
        }
        GetFunctionResponse other = (GetFunctionResponse)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.configuration() != null) {
            sb.append("Configuration: ").append(this.configuration()).append(",");
        }
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
            case "Code": {
                return Optional.of(clazz.cast(this.code()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private FunctionConfiguration configuration;
        private FunctionCodeLocation code;
        private Map<String, String> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionResponse model) {
            this.configuration(model.configuration);
            this.code(model.code);
            this.tags(model.tags);
        }

        public final FunctionConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(FunctionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(FunctionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final FunctionCodeLocation.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        @Override
        public final Builder code(FunctionCodeLocation code) {
            this.code = code;
            return this;
        }

        public final void setCode(FunctionCodeLocation.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public GetFunctionResponse build() {
            return new GetFunctionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetFunctionResponse> {
        public Builder configuration(FunctionConfiguration var1);

        default public Builder configuration(Consumer<FunctionConfiguration.Builder> configuration) {
            return this.configuration((FunctionConfiguration)((FunctionConfiguration.Builder)FunctionConfiguration.builder().apply(configuration)).build());
        }

        public Builder code(FunctionCodeLocation var1);

        default public Builder code(Consumer<FunctionCodeLocation.Builder> code) {
            return this.code((FunctionCodeLocation)((FunctionCodeLocation.Builder)FunctionCodeLocation.builder().apply(code)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

