/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFunctionCodeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateFunctionCodeRequest> {
    private final String functionName;
    private final ByteBuffer zipFile;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3ObjectVersion;
    private final Boolean publish;
    private final Boolean dryRun;

    private UpdateFunctionCodeRequest(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.zipFile = builder.zipFile;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
        this.publish = builder.publish;
        this.dryRun = builder.dryRun;
    }

    public String functionName() {
        return this.functionName;
    }

    public ByteBuffer zipFile() {
        return this.zipFile == null ? null : this.zipFile.asReadOnlyBuffer();
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public String s3ObjectVersion() {
        return this.s3ObjectVersion;
    }

    public Boolean publish() {
        return this.publish;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.functionName() == null ? 0 : this.functionName().hashCode());
        hashCode = 31 * hashCode + (this.zipFile() == null ? 0 : this.zipFile().hashCode());
        hashCode = 31 * hashCode + (this.s3Bucket() == null ? 0 : this.s3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.s3Key() == null ? 0 : this.s3Key().hashCode());
        hashCode = 31 * hashCode + (this.s3ObjectVersion() == null ? 0 : this.s3ObjectVersion().hashCode());
        hashCode = 31 * hashCode + (this.publish() == null ? 0 : this.publish().hashCode());
        hashCode = 31 * hashCode + (this.dryRun() == null ? 0 : this.dryRun().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionCodeRequest)) {
            return false;
        }
        UpdateFunctionCodeRequest other = (UpdateFunctionCodeRequest)((Object)obj);
        if (other.functionName() == null ^ this.functionName() == null) {
            return false;
        }
        if (other.functionName() != null && !other.functionName().equals(this.functionName())) {
            return false;
        }
        if (other.zipFile() == null ^ this.zipFile() == null) {
            return false;
        }
        if (other.zipFile() != null && !other.zipFile().equals(this.zipFile())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Key() == null ^ this.s3Key() == null) {
            return false;
        }
        if (other.s3Key() != null && !other.s3Key().equals(this.s3Key())) {
            return false;
        }
        if (other.s3ObjectVersion() == null ^ this.s3ObjectVersion() == null) {
            return false;
        }
        if (other.s3ObjectVersion() != null && !other.s3ObjectVersion().equals(this.s3ObjectVersion())) {
            return false;
        }
        if (other.publish() == null ^ this.publish() == null) {
            return false;
        }
        if (other.publish() != null && !other.publish().equals(this.publish())) {
            return false;
        }
        if (other.dryRun() == null ^ this.dryRun() == null) {
            return false;
        }
        return other.dryRun() == null || other.dryRun().equals(this.dryRun());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.zipFile() != null) {
            sb.append("ZipFile: ").append(this.zipFile()).append(",");
        }
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3Key() != null) {
            sb.append("S3Key: ").append(this.s3Key()).append(",");
        }
        if (this.s3ObjectVersion() != null) {
            sb.append("S3ObjectVersion: ").append(this.s3ObjectVersion()).append(",");
        }
        if (this.publish() != null) {
            sb.append("Publish: ").append(this.publish()).append(",");
        }
        if (this.dryRun() != null) {
            sb.append("DryRun: ").append(this.dryRun()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "ZipFile": {
                return Optional.of(clazz.cast(this.zipFile()));
            }
            case "S3Bucket": {
                return Optional.of(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.of(clazz.cast(this.s3Key()));
            }
            case "S3ObjectVersion": {
                return Optional.of(clazz.cast(this.s3ObjectVersion()));
            }
            case "Publish": {
                return Optional.of(clazz.cast(this.publish()));
            }
            case "DryRun": {
                return Optional.of(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private ByteBuffer zipFile;
        private String s3Bucket;
        private String s3Key;
        private String s3ObjectVersion;
        private Boolean publish;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionCodeRequest model) {
            this.functionName(model.functionName);
            this.zipFile(model.zipFile);
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.s3ObjectVersion(model.s3ObjectVersion);
            this.publish(model.publish);
            this.dryRun(model.dryRun);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final ByteBuffer getZipFile() {
            return this.zipFile;
        }

        @Override
        public final Builder zipFile(ByteBuffer zipFile) {
            this.zipFile = StandardMemberCopier.copy((ByteBuffer)zipFile);
            return this;
        }

        public final void setZipFile(ByteBuffer zipFile) {
            this.zipFile = StandardMemberCopier.copy((ByteBuffer)zipFile);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getS3ObjectVersion() {
            return this.s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        public final Boolean getPublish() {
            return this.publish;
        }

        @Override
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        public UpdateFunctionCodeRequest build() {
            return new UpdateFunctionCodeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateFunctionCodeRequest> {
        public Builder functionName(String var1);

        public Builder zipFile(ByteBuffer var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3ObjectVersion(String var1);

        public Builder publish(Boolean var1);

        public Builder dryRun(Boolean var1);
    }
}

