/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.FunctionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListVersionsByFunctionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListVersionsByFunctionResponse> {
    private final String nextMarker;
    private final List<FunctionConfiguration> versions;

    private ListVersionsByFunctionResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.versions = builder.versions;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<FunctionConfiguration> versions() {
        return this.versions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.versions() == null ? 0 : this.versions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVersionsByFunctionResponse)) {
            return false;
        }
        ListVersionsByFunctionResponse other = (ListVersionsByFunctionResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.versions() == null ^ this.versions() == null) {
            return false;
        }
        return other.versions() == null || other.versions().equals(this.versions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.versions() != null) {
            sb.append("Versions: ").append(this.versions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "Versions": {
                return Optional.of(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<FunctionConfiguration> versions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVersionsByFunctionResponse model) {
            this.nextMarker(model.nextMarker);
            this.versions(model.versions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<FunctionConfiguration.Builder> getVersions() {
            return this.versions != null ? (Collection)this.versions.stream().map(FunctionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<FunctionConfiguration> versions) {
            this.versions = FunctionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(FunctionConfiguration ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<FunctionConfiguration.BuilderImpl> versions) {
            this.versions = FunctionListCopier.copyFromBuilder(versions);
        }

        public ListVersionsByFunctionResponse build() {
            return new ListVersionsByFunctionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListVersionsByFunctionResponse> {
        public Builder nextMarker(String var1);

        public Builder versions(Collection<FunctionConfiguration> var1);

        public Builder versions(FunctionConfiguration ... var1);
    }
}

