/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lambda.model.InvocationType;
import software.amazon.awssdk.services.lambda.model.LogType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InvokeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, InvokeRequest> {
    private final String functionName;
    private final String invocationType;
    private final String logType;
    private final String clientContext;
    private final ByteBuffer payload;
    private final String qualifier;

    private InvokeRequest(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.invocationType = builder.invocationType;
        this.logType = builder.logType;
        this.clientContext = builder.clientContext;
        this.payload = builder.payload;
        this.qualifier = builder.qualifier;
    }

    public String functionName() {
        return this.functionName;
    }

    public InvocationType invocationType() {
        return InvocationType.fromValue(this.invocationType);
    }

    public String invocationTypeString() {
        return this.invocationType;
    }

    public LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public String logTypeString() {
        return this.logType;
    }

    public String clientContext() {
        return this.clientContext;
    }

    public ByteBuffer payload() {
        return this.payload == null ? null : this.payload.asReadOnlyBuffer();
    }

    public String qualifier() {
        return this.qualifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.functionName() == null ? 0 : this.functionName().hashCode());
        hashCode = 31 * hashCode + (this.invocationTypeString() == null ? 0 : this.invocationTypeString().hashCode());
        hashCode = 31 * hashCode + (this.logTypeString() == null ? 0 : this.logTypeString().hashCode());
        hashCode = 31 * hashCode + (this.clientContext() == null ? 0 : this.clientContext().hashCode());
        hashCode = 31 * hashCode + (this.payload() == null ? 0 : this.payload().hashCode());
        hashCode = 31 * hashCode + (this.qualifier() == null ? 0 : this.qualifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRequest)) {
            return false;
        }
        InvokeRequest other = (InvokeRequest)((Object)obj);
        if (other.functionName() == null ^ this.functionName() == null) {
            return false;
        }
        if (other.functionName() != null && !other.functionName().equals(this.functionName())) {
            return false;
        }
        if (other.invocationTypeString() == null ^ this.invocationTypeString() == null) {
            return false;
        }
        if (other.invocationTypeString() != null && !other.invocationTypeString().equals(this.invocationTypeString())) {
            return false;
        }
        if (other.logTypeString() == null ^ this.logTypeString() == null) {
            return false;
        }
        if (other.logTypeString() != null && !other.logTypeString().equals(this.logTypeString())) {
            return false;
        }
        if (other.clientContext() == null ^ this.clientContext() == null) {
            return false;
        }
        if (other.clientContext() != null && !other.clientContext().equals(this.clientContext())) {
            return false;
        }
        if (other.payload() == null ^ this.payload() == null) {
            return false;
        }
        if (other.payload() != null && !other.payload().equals(this.payload())) {
            return false;
        }
        if (other.qualifier() == null ^ this.qualifier() == null) {
            return false;
        }
        return other.qualifier() == null || other.qualifier().equals(this.qualifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.invocationTypeString() != null) {
            sb.append("InvocationType: ").append(this.invocationTypeString()).append(",");
        }
        if (this.logTypeString() != null) {
            sb.append("LogType: ").append(this.logTypeString()).append(",");
        }
        if (this.clientContext() != null) {
            sb.append("ClientContext: ").append(this.clientContext()).append(",");
        }
        if (this.payload() != null) {
            sb.append("Payload: ").append(this.payload()).append(",");
        }
        if (this.qualifier() != null) {
            sb.append("Qualifier: ").append(this.qualifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "InvocationType": {
                return Optional.of(clazz.cast(this.invocationTypeString()));
            }
            case "LogType": {
                return Optional.of(clazz.cast(this.logTypeString()));
            }
            case "ClientContext": {
                return Optional.of(clazz.cast(this.clientContext()));
            }
            case "Payload": {
                return Optional.of(clazz.cast(this.payload()));
            }
            case "Qualifier": {
                return Optional.of(clazz.cast(this.qualifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String invocationType;
        private String logType;
        private String clientContext;
        private ByteBuffer payload;
        private String qualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeRequest model) {
            this.functionName(model.functionName);
            this.invocationType(model.invocationType);
            this.logType(model.logType);
            this.clientContext(model.clientContext);
            this.payload(model.payload);
            this.qualifier(model.qualifier);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getInvocationType() {
            return this.invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType.toString());
            return this;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        public final String getLogType() {
            return this.logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType.toString());
            return this;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        public final ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public InvokeRequest build() {
            return new InvokeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InvokeRequest> {
        public Builder functionName(String var1);

        public Builder invocationType(String var1);

        public Builder invocationType(InvocationType var1);

        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder clientContext(String var1);

        public Builder payload(ByteBuffer var1);

        public Builder qualifier(String var1);
    }
}

