/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFunctionConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetFunctionConfigurationRequest> {
    private final String functionName;
    private final String qualifier;

    private GetFunctionConfigurationRequest(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
    }

    public String functionName() {
        return this.functionName;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.functionName() == null ? 0 : this.functionName().hashCode());
        hashCode = 31 * hashCode + (this.qualifier() == null ? 0 : this.qualifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionConfigurationRequest)) {
            return false;
        }
        GetFunctionConfigurationRequest other = (GetFunctionConfigurationRequest)((Object)obj);
        if (other.functionName() == null ^ this.functionName() == null) {
            return false;
        }
        if (other.functionName() != null && !other.functionName().equals(this.functionName())) {
            return false;
        }
        if (other.qualifier() == null ^ this.qualifier() == null) {
            return false;
        }
        return other.qualifier() == null || other.qualifier().equals(this.qualifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.qualifier() != null) {
            sb.append("Qualifier: ").append(this.qualifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "Qualifier": {
                return Optional.of(clazz.cast(this.qualifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String qualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionConfigurationRequest model) {
            this.functionName(model.functionName);
            this.qualifier(model.qualifier);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public GetFunctionConfigurationRequest build() {
            return new GetFunctionConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetFunctionConfigurationRequest> {
        public Builder functionName(String var1);

        public Builder qualifier(String var1);
    }
}

