/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lambda.model.EnvironmentResponse;
import software.amazon.awssdk.services.lambda.transform.EnvironmentErrorUnmarshaller;

public class EnvironmentResponseUnmarshaller
implements Unmarshaller<EnvironmentResponse, JsonUnmarshallerContext> {
    private static final EnvironmentResponseUnmarshaller INSTANCE = new EnvironmentResponseUnmarshaller();

    public EnvironmentResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        EnvironmentResponse.Builder environmentResponseBuilder = EnvironmentResponse.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Variables", targetDepth)) {
                    context.nextToken();
                    environmentResponseBuilder.variables(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Error", targetDepth)) {
                    context.nextToken();
                    environmentResponseBuilder.error(EnvironmentErrorUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EnvironmentResponse)environmentResponseBuilder.build();
    }

    public static EnvironmentResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

