/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.EnvironmentError;
import software.amazon.awssdk.services.lambda.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.lambda.transform.EnvironmentResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentResponse> {
    private final Map<String, String> variables;
    private final EnvironmentError error;

    private EnvironmentResponse(BuilderImpl builder) {
        this.variables = builder.variables;
        this.error = builder.error;
    }

    public Map<String, String> variables() {
        return this.variables;
    }

    public EnvironmentError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.variables() == null ? 0 : this.variables().hashCode());
        hashCode = 31 * hashCode + (this.error() == null ? 0 : this.error().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResponse)) {
            return false;
        }
        EnvironmentResponse other = (EnvironmentResponse)obj;
        if (other.variables() == null ^ this.variables() == null) {
            return false;
        }
        if (other.variables() != null && !other.variables().equals(this.variables())) {
            return false;
        }
        if (other.error() == null ^ this.error() == null) {
            return false;
        }
        return other.error() == null || other.error().equals(this.error());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.variables() != null) {
            sb.append("Variables: ").append(this.variables()).append(",");
        }
        if (this.error() != null) {
            sb.append("Error: ").append(this.error()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, String> variables;
        private EnvironmentError error;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResponse model) {
            this.setVariables(model.variables);
            this.setError(model.error);
        }

        public final Map<String, String> getVariables() {
            return this.variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
        }

        public final EnvironmentError getError() {
            return this.error;
        }

        @Override
        public final Builder error(EnvironmentError error) {
            this.error = error;
            return this;
        }

        public final void setError(EnvironmentError error) {
            this.error = error;
        }

        public EnvironmentResponse build() {
            return new EnvironmentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentResponse> {
        public Builder variables(Map<String, String> var1);

        public Builder error(EnvironmentError var1);
    }
}

