/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.FunctionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFunctionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListFunctionsResponse> {
    private final String nextMarker;
    private final List<FunctionConfiguration> functions;

    private ListFunctionsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.functions = builder.functions;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<FunctionConfiguration> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.functions() == null ? 0 : this.functions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsResponse)) {
            return false;
        }
        ListFunctionsResponse other = (ListFunctionsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.functions() == null ^ this.functions() == null) {
            return false;
        }
        return other.functions() == null || other.functions().equals(this.functions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.functions() != null) {
            sb.append("Functions: ").append(this.functions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<FunctionConfiguration> functions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsResponse model) {
            this.setNextMarker(model.nextMarker);
            this.setFunctions(model.functions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<FunctionConfiguration> getFunctions() {
            return this.functions;
        }

        @Override
        public final Builder functions(Collection<FunctionConfiguration> functions) {
            this.functions = FunctionListCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(FunctionConfiguration ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        public final void setFunctions(Collection<FunctionConfiguration> functions) {
            this.functions = FunctionListCopier.copy(functions);
        }

        @SafeVarargs
        public final void setFunctions(FunctionConfiguration ... functions) {
            this.functions(Arrays.asList(functions));
        }

        public ListFunctionsResponse build() {
            return new ListFunctionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListFunctionsResponse> {
        public Builder nextMarker(String var1);

        public Builder functions(Collection<FunctionConfiguration> var1);

        public Builder functions(FunctionConfiguration ... var1);
    }
}

