/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.transform.EnvironmentErrorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentError
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentError> {
    private final String errorCode;
    private final String message;

    private EnvironmentError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.errorCode() == null ? 0 : this.errorCode().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentError)) {
            return false;
        }
        EnvironmentError other = (EnvironmentError)obj;
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        return other.message() == null || other.message().equals(this.message());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentError model) {
            this.setErrorCode(model.errorCode);
            this.setMessage(model.message);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public EnvironmentError build() {
            return new EnvironmentError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentError> {
        public Builder errorCode(String var1);

        public Builder message(String var1);
    }
}

