/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAliasRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CreateAliasRequest> {
    private final String functionName;
    private final String name;
    private final String functionVersion;
    private final String description;
    private final AliasRoutingConfiguration routingConfig;

    private CreateAliasRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.name = builder.name;
        this.functionVersion = builder.functionVersion;
        this.description = builder.description;
        this.routingConfig = builder.routingConfig;
    }

    public String functionName() {
        return this.functionName;
    }

    public String name() {
        return this.name;
    }

    public String functionVersion() {
        return this.functionVersion;
    }

    public String description() {
        return this.description;
    }

    public AliasRoutingConfiguration routingConfig() {
        return this.routingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAliasRequest)) {
            return false;
        }
        CreateAliasRequest other = (CreateAliasRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.functionVersion(), other.functionVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.routingConfig(), other.routingConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateAliasRequest").add("FunctionName", (Object)this.functionName()).add("Name", (Object)this.name()).add("FunctionVersion", (Object)this.functionVersion()).add("Description", (Object)this.description()).add("RoutingConfig", (Object)this.routingConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FunctionVersion": {
                return Optional.ofNullable(clazz.cast(this.functionVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.routingConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String name;
        private String functionVersion;
        private String description;
        private AliasRoutingConfiguration routingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAliasRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.name(model.name);
            this.functionVersion(model.functionVersion);
            this.description(model.description);
            this.routingConfig(model.routingConfig);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final AliasRoutingConfiguration.Builder getRoutingConfig() {
            return this.routingConfig != null ? this.routingConfig.toBuilder() : null;
        }

        @Override
        public final Builder routingConfig(AliasRoutingConfiguration routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final void setRoutingConfig(AliasRoutingConfiguration.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAliasRequest build() {
            return new CreateAliasRequest(this);
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    CopyableBuilder<Builder, CreateAliasRequest> {
        public Builder functionName(String var1);

        public Builder name(String var1);

        public Builder functionVersion(String var1);

        public Builder description(String var1);

        public Builder routingConfig(AliasRoutingConfiguration var1);

        default public Builder routingConfig(Consumer<AliasRoutingConfiguration.Builder> routingConfig) {
            return this.routingConfig((AliasRoutingConfiguration)((AliasRoutingConfiguration.Builder)AliasRoutingConfiguration.builder().applyMutation(routingConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

