/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventSourceMappingRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, UpdateEventSourceMappingRequest> {
    private final String uuid;
    private final String functionName;
    private final Boolean enabled;
    private final Integer batchSize;

    private UpdateEventSourceMappingRequest(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.functionName = builder.functionName;
        this.enabled = builder.enabled;
        this.batchSize = builder.batchSize;
    }

    public String uuid() {
        return this.uuid;
    }

    public String functionName() {
        return this.functionName;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer batchSize() {
        return this.batchSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventSourceMappingRequest)) {
            return false;
        }
        UpdateEventSourceMappingRequest other = (UpdateEventSourceMappingRequest)((Object)obj);
        return Objects.equals(this.uuid(), other.uuid()) && Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.batchSize(), other.batchSize());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEventSourceMappingRequest").add("UUID", (Object)this.uuid()).add("FunctionName", (Object)this.functionName()).add("Enabled", (Object)this.enabled()).add("BatchSize", (Object)this.batchSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UUID": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String uuid;
        private String functionName;
        private Boolean enabled;
        private Integer batchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventSourceMappingRequest model) {
            super(model);
            this.uuid(model.uuid);
            this.functionName(model.functionName);
            this.enabled(model.enabled);
            this.batchSize(model.batchSize);
        }

        public final String getUUID() {
            return this.uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final void setUUID(String uuid) {
            this.uuid = uuid;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventSourceMappingRequest build() {
            return new UpdateEventSourceMappingRequest(this);
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    CopyableBuilder<Builder, UpdateEventSourceMappingRequest> {
        public Builder uuid(String var1);

        public Builder functionName(String var1);

        public Builder enabled(Boolean var1);

        public Builder batchSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

