/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListFunctionsRequestModelMarshaller {
    private static final MarshallingInfo<String> MASTERREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("MasterRegion").isBinary(false).build();
    private static final MarshallingInfo<String> FUNCTIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("FunctionVersion").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Marker").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("MaxItems").isBinary(false).build();
    private static final ListFunctionsRequestModelMarshaller INSTANCE = new ListFunctionsRequestModelMarshaller();

    private ListFunctionsRequestModelMarshaller() {
    }

    public static ListFunctionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListFunctionsRequest listFunctionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listFunctionsRequest), (String)"listFunctionsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listFunctionsRequest.masterRegion(), MASTERREGION_BINDING);
            protocolMarshaller.marshall((Object)listFunctionsRequest.functionVersionAsString(), FUNCTIONVERSION_BINDING);
            protocolMarshaller.marshall((Object)listFunctionsRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall((Object)listFunctionsRequest.maxItems(), MAXITEMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

