/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FunctionConfigurationMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionName").isBinary(false).build();
    private static final MarshallingInfo<String> FUNCTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionArn").isBinary(false).build();
    private static final MarshallingInfo<String> RUNTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Runtime").isBinary(false).build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").isBinary(false).build();
    private static final MarshallingInfo<String> HANDLER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Handler").isBinary(false).build();
    private static final MarshallingInfo<Long> CODESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSize").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeout").isBinary(false).build();
    private static final MarshallingInfo<Integer> MEMORYSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemorySize").isBinary(false).build();
    private static final MarshallingInfo<String> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").isBinary(false).build();
    private static final MarshallingInfo<String> CODESHA256_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSha256").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEADLETTERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeadLetterConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSKeyArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TRACINGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TracingConfig").isBinary(false).build();
    private static final MarshallingInfo<String> MASTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterArn").isBinary(false).build();
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RevisionId").isBinary(false).build();
    private static final FunctionConfigurationMarshaller INSTANCE = new FunctionConfigurationMarshaller();

    private FunctionConfigurationMarshaller() {
    }

    public static FunctionConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FunctionConfiguration functionConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)functionConfiguration, (String)"functionConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)functionConfiguration.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.functionArn(), FUNCTIONARN_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.runtimeAsString(), RUNTIME_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.role(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.handler(), HANDLER_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.codeSize(), CODESIZE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.timeout(), TIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.memorySize(), MEMORYSIZE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.lastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.codeSha256(), CODESHA256_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.vpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.deadLetterConfig(), DEADLETTERCONFIG_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.kmsKeyArn(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.tracingConfig(), TRACINGCONFIG_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.masterArn(), MASTERARN_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.revisionId(), REVISIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

