/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventSourceMappingConfigurationMarshaller {
    private static final MarshallingInfo<String> UUID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UUID").isBinary(false).build();
    private static final MarshallingInfo<Integer> BATCHSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchSize").isBinary(false).build();
    private static final MarshallingInfo<String> EVENTSOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventSourceArn").isBinary(false).build();
    private static final MarshallingInfo<String> FUNCTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").isBinary(false).build();
    private static final MarshallingInfo<String> LASTPROCESSINGRESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastProcessingResult").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<String> STATETRANSITIONREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateTransitionReason").isBinary(false).build();
    private static final EventSourceMappingConfigurationMarshaller INSTANCE = new EventSourceMappingConfigurationMarshaller();

    private EventSourceMappingConfigurationMarshaller() {
    }

    public static EventSourceMappingConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventSourceMappingConfiguration eventSourceMappingConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventSourceMappingConfiguration, (String)"eventSourceMappingConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventSourceMappingConfiguration.uuid(), UUID_BINDING);
            protocolMarshaller.marshall((Object)eventSourceMappingConfiguration.batchSize(), BATCHSIZE_BINDING);
            protocolMarshaller.marshall((Object)eventSourceMappingConfiguration.eventSourceArn(), EVENTSOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)eventSourceMappingConfiguration.functionArn(), FUNCTIONARN_BINDING);
            protocolMarshaller.marshall((Object)eventSourceMappingConfiguration.lastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)eventSourceMappingConfiguration.lastProcessingResult(), LASTPROCESSINGRESULT_BINDING);
            protocolMarshaller.marshall((Object)eventSourceMappingConfiguration.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)eventSourceMappingConfiguration.stateTransitionReason(), STATETRANSITIONREASON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

