/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateEventSourceMappingRequestModelMarshaller {
    private static final MarshallingInfo<String> EVENTSOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventSourceArn").isBinary(false).build();
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<Integer> BATCHSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchSize").isBinary(false).build();
    private static final MarshallingInfo<String> STARTINGPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingPosition").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTINGPOSITIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingPositionTimestamp").isBinary(false).build();
    private static final CreateEventSourceMappingRequestModelMarshaller INSTANCE = new CreateEventSourceMappingRequestModelMarshaller();

    private CreateEventSourceMappingRequestModelMarshaller() {
    }

    public static CreateEventSourceMappingRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateEventSourceMappingRequest createEventSourceMappingRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createEventSourceMappingRequest), (String)"createEventSourceMappingRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createEventSourceMappingRequest.eventSourceArn(), EVENTSOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)createEventSourceMappingRequest.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)createEventSourceMappingRequest.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)createEventSourceMappingRequest.batchSize(), BATCHSIZE_BINDING);
            protocolMarshaller.marshall((Object)createEventSourceMappingRequest.startingPositionAsString(), STARTINGPOSITION_BINDING);
            protocolMarshaller.marshall((Object)createEventSourceMappingRequest.startingPositionTimestamp(), STARTINGPOSITIONTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

