/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;

public class ListEventSourceMappingsIterable
implements SdkIterable<ListEventSourceMappingsResponse> {
    private final LambdaClient client;
    private final ListEventSourceMappingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventSourceMappingsIterable(LambdaClient client, ListEventSourceMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEventSourceMappingsResponseFetcher();
    }

    public Iterator<ListEventSourceMappingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<EventSourceMappingConfiguration> eventSourceMappings() {
        Function<ListEventSourceMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventSourceMappings() != null) {
                return response.eventSourceMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListEventSourceMappingsIterable resume(ListEventSourceMappingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEventSourceMappingsIterable(this.client, (ListEventSourceMappingsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListEventSourceMappingsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListEventSourceMappingsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListEventSourceMappingsResponseFetcher
    implements SyncPageFetcher<ListEventSourceMappingsResponse> {
        private ListEventSourceMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventSourceMappingsResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public ListEventSourceMappingsResponse nextPage(ListEventSourceMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListEventSourceMappingsIterable.this.client.listEventSourceMappings(ListEventSourceMappingsIterable.this.firstRequest);
            }
            return ListEventSourceMappingsIterable.this.client.listEventSourceMappings((ListEventSourceMappingsRequest)((Object)ListEventSourceMappingsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

