/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.invoke;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.invoke.DefaultLambdaFunctionNameResolver;
import software.amazon.awssdk.services.lambda.invoke.LambdaFunction;
import software.amazon.awssdk.services.lambda.invoke.LambdaFunctionException;
import software.amazon.awssdk.services.lambda.invoke.LambdaFunctionNameResolver;
import software.amazon.awssdk.services.lambda.invoke.LambdaInvokerFactoryConfig;
import software.amazon.awssdk.services.lambda.invoke.LambdaSerializationException;
import software.amazon.awssdk.services.lambda.model.InvocationType;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.LogType;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.Base64Utils;
import software.amazon.awssdk.utils.BinaryUtils;

public final class LambdaInvokerFactory {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);

    private LambdaInvokerFactory() {
    }

    @Deprecated
    public static <T> T build(Class<T> interfaceClass, LambdaAsyncClient awsLambda) {
        return LambdaInvokerFactory.build(interfaceClass, awsLambda, new LambdaInvokerFactoryConfig());
    }

    @Deprecated
    public static <T> T build(Class<T> interfaceClass, LambdaAsyncClient awsLambda, LambdaInvokerFactoryConfig config) {
        Object proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new LambdaInvocationHandler(interfaceClass, awsLambda, config));
        return interfaceClass.cast(proxy);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class LambdaInvocationHandler
    implements InvocationHandler {
        private final LambdaAsyncClient awsLambda;
        private final Log log;
        private final LambdaInvokerFactoryConfig config;

        public LambdaInvocationHandler(Class<?> interfaceClass, LambdaAsyncClient awsLambda, LambdaInvokerFactoryConfig config) {
            this.awsLambda = awsLambda;
            this.log = LogFactory.getLog(interfaceClass);
            this.config = config;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            LambdaFunction annotation = this.validateInterfaceMethod(method, args);
            InvokeRequest invokeRequest = this.buildInvokeRequest(method, annotation, args == null ? null : args[0]);
            InvokeResponse invokeResult = this.awsLambda.invoke(invokeRequest).get();
            return this.processInvokeResponse(method, invokeResult);
        }

        private LambdaFunction validateInterfaceMethod(Method method, Object[] args) {
            LambdaFunction annotation = method.getAnnotation(LambdaFunction.class);
            if (annotation == null) {
                throw new LambdaSerializationException("No LambdaFunction annotation for method " + method.getName());
            }
            if (annotation.invocationType() != InvocationType.RequestResponse && annotation.logType() != LogType.None) {
                throw new LambdaSerializationException("InvocationType must be RequestResponse if LogType is set");
            }
            if (args != null && args.length > 1) {
                throw new LambdaSerializationException("LambdaFunctions take either 0 or 1 arguments");
            }
            return annotation;
        }

        private InvokeRequest buildInvokeRequest(Method method, LambdaFunction annotation, Object input) {
            InvokeRequest.Builder invokeRequestBuilder = InvokeRequest.builder();
            String functionName = this.config.getLambdaFunctionNameResolver().getFunctionName(method, annotation, this.config);
            invokeRequestBuilder.functionName(functionName);
            if (this.hasQualifier()) {
                invokeRequestBuilder.qualifier(this.getQualifier());
            }
            invokeRequestBuilder.invocationType(annotation.invocationType());
            invokeRequestBuilder.logType(annotation.logType());
            if (input != null) {
                try {
                    String payload = MAPPER.writer().writeValueAsString(input);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Serialized request object to '" + payload + "'"));
                    }
                    invokeRequestBuilder.payload(ByteBuffer.wrap(payload.getBytes(StandardCharsets.UTF_8)));
                }
                catch (JsonProcessingException ex) {
                    throw new LambdaSerializationException("Failed to serialize request object to JSON", ex);
                }
            }
            return (InvokeRequest)((Object)invokeRequestBuilder.build());
        }

        private boolean hasQualifier() {
            return this.getQualifier() != null;
        }

        private String getQualifier() {
            return this.config.getFunctionAlias() == null ? this.config.getFunctionVersion() : this.config.getFunctionAlias();
        }

        private Object processInvokeResponse(Method method, InvokeResponse invokeResult) throws Throwable {
            String functionError;
            if (invokeResult.logResult() != null && this.log.isInfoEnabled()) {
                try {
                    String decoded = new String(Base64Utils.decode((String)invokeResult.logResult()), StringUtils.UTF8);
                    this.log.info((Object)(method.getName() + " log:\n\t" + decoded.replaceAll("\n", "\n\t")));
                }
                catch (Exception ex) {
                    this.log.warn((Object)("Error decoding log result '" + invokeResult.logResult() + "'"), (Throwable)ex);
                }
            }
            if ((functionError = invokeResult.functionError()) == null) {
                return this.getObjectFromPayload(method, invokeResult);
            }
            throw this.getExceptionFromPayload(method, invokeResult);
        }

        private Object getObjectFromPayload(Method method, InvokeResponse invokeResult) {
            try {
                return this.getObjectFromPayload(method.getGenericReturnType(), invokeResult.payload());
            }
            catch (IOException ex) {
                throw new LambdaSerializationException("Failed to parse Lambda function result", ex);
            }
        }

        private Throwable getExceptionFromPayload(Method method, InvokeResponse invokeResult) {
            try {
                LambdaFunctionException error = this.getObjectFromPayload(LambdaFunctionException.class, invokeResult.payload());
                error.setFunctionError(invokeResult.functionError());
                error.fillInStackTrace(method.getDeclaringClass());
                return this.getExceptionToThrow(method, error);
            }
            catch (Exception ex) {
                this.log.warn((Object)"Error parsing exception information from response payload", (Throwable)ex);
                return new LambdaFunctionException("Unexpected error executing Lambda function", invokeResult.functionError());
            }
        }

        private Throwable getExceptionToThrow(Method method, LambdaFunctionException error) {
            String type = error.getType();
            Constructor<?> constructor = this.findConstructor(this.findCustomExceptionClass(method, type));
            if (constructor != null) {
                try {
                    Throwable toReturn = (Throwable)constructor.newInstance(error.getMessage());
                    toReturn.setStackTrace(error.getStackTrace());
                    return toReturn;
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Error constructing custom exception", (Throwable)ex);
                }
            }
            return error;
        }

        private Class<?> findCustomExceptionClass(Method method, String type) {
            if (type != null) {
                for (Class<?> exceptionType : method.getExceptionTypes()) {
                    if (!exceptionType.getName().equals(type) && !exceptionType.getSimpleName().equals(type)) continue;
                    return exceptionType;
                }
            }
            return null;
        }

        private Constructor<?> findConstructor(Class<?> type) {
            if (type == null) {
                return null;
            }
            for (Constructor<?> constructor : type.getConstructors()) {
                Class<?>[] params = constructor.getParameterTypes();
                if (params == null || params.length != 1 || !String.class.equals(params[0])) continue;
                return constructor;
            }
            return null;
        }

        private <T> T getObjectFromPayload(Class<T> type, ByteBuffer payload) throws IOException {
            return type.cast(this.getObjectFromPayload((Type)type, payload));
        }

        private Object getObjectFromPayload(Type type, ByteBuffer payload) throws IOException {
            if (type == Void.TYPE || payload.remaining() == 0) {
                return null;
            }
            JavaType javaType = MAPPER.getTypeFactory().constructType(type);
            return MAPPER.reader(javaType).readValue(BinaryUtils.copyAllBytesFrom((ByteBuffer)payload));
        }
    }

    public static class Builder {
        private LambdaFunctionNameResolver functionNameResolver;
        private String functionAlias;
        private String functionVersion;
        private LambdaAsyncClient lambda;

        public Builder lambdaFunctionNameResolver(LambdaFunctionNameResolver functionNameResolver) {
            this.functionNameResolver = functionNameResolver;
            return this;
        }

        private LambdaFunctionNameResolver resolveFunctionNameResolver() {
            return this.functionNameResolver == null ? new DefaultLambdaFunctionNameResolver() : this.functionNameResolver;
        }

        public Builder functionAlias(String functionAlias) {
            this.functionAlias = functionAlias;
            return this;
        }

        public Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public Builder lambdaClient(LambdaAsyncClient lambda) {
            this.lambda = lambda;
            return this;
        }

        private LambdaAsyncClient resolveLambdaClient() {
            return this.lambda == null ? (LambdaAsyncClient)LambdaAsyncClient.builder().build() : this.lambda;
        }

        public <T> T build(Class<T> interfaceClass) {
            return LambdaInvokerFactory.build(interfaceClass, this.resolveLambdaClient(), this.getConfiguration());
        }

        private LambdaInvokerFactoryConfig getConfiguration() {
            return new LambdaInvokerFactoryConfig(this.resolveFunctionNameResolver(), this.functionAlias, this.functionVersion);
        }
    }
}

