/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lakeformation.model.RedshiftScopeUnion;
import software.amazon.awssdk.services.lakeformation.model.RedshiftServiceIntegrationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceIntegrationUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceIntegrationUnion> {
    private static final SdkField<List<RedshiftScopeUnion>> REDSHIFT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Redshift").getter(ServiceIntegrationUnion.getter(ServiceIntegrationUnion::redshift)).setter(ServiceIntegrationUnion.setter(Builder::redshift)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redshift").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RedshiftScopeUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceIntegrationUnion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RedshiftScopeUnion> redshift;
    private final Type type;

    private ServiceIntegrationUnion(BuilderImpl builder) {
        this.redshift = builder.redshift;
        this.type = builder.type;
    }

    public final boolean hasRedshift() {
        return this.redshift != null && !(this.redshift instanceof SdkAutoConstructList);
    }

    public final List<RedshiftScopeUnion> redshift() {
        return this.redshift;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRedshift() ? this.redshift() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceIntegrationUnion)) {
            return false;
        }
        ServiceIntegrationUnion other = (ServiceIntegrationUnion)obj;
        return this.hasRedshift() == other.hasRedshift() && Objects.equals(this.redshift(), other.redshift());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceIntegrationUnion").add("Redshift", this.hasRedshift() ? this.redshift() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Redshift": {
                return Optional.ofNullable(clazz.cast(this.redshift()));
            }
        }
        return Optional.empty();
    }

    public static ServiceIntegrationUnion fromRedshift(List<RedshiftScopeUnion> redshift) {
        return (ServiceIntegrationUnion)ServiceIntegrationUnion.builder().redshift(redshift).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RedshiftScopeUnion>>> map = new HashMap<String, SdkField<List<RedshiftScopeUnion>>>();
        map.put("Redshift", REDSHIFT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceIntegrationUnion, T> g) {
        return obj -> g.apply((ServiceIntegrationUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        REDSHIFT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<RedshiftScopeUnion> redshift = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceIntegrationUnion model) {
            this.redshift(model.redshift);
        }

        public final List<RedshiftScopeUnion.Builder> getRedshift() {
            List<RedshiftScopeUnion.Builder> result = RedshiftServiceIntegrationsCopier.copyToBuilder(this.redshift);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRedshift(Collection<RedshiftScopeUnion.BuilderImpl> redshift) {
            List<RedshiftScopeUnion> oldValue = this.redshift;
            this.redshift = RedshiftServiceIntegrationsCopier.copyFromBuilder(redshift);
            this.handleUnionValueChange(Type.REDSHIFT, oldValue, this.redshift);
        }

        @Override
        public final Builder redshift(Collection<RedshiftScopeUnion> redshift) {
            List<RedshiftScopeUnion> oldValue = this.redshift;
            this.redshift = RedshiftServiceIntegrationsCopier.copy(redshift);
            this.handleUnionValueChange(Type.REDSHIFT, oldValue, this.redshift);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redshift(RedshiftScopeUnion ... redshift) {
            this.redshift(Arrays.asList(redshift));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redshift(Consumer<RedshiftScopeUnion.Builder> ... redshift) {
            this.redshift(Stream.of(redshift).map(c -> (RedshiftScopeUnion)((RedshiftScopeUnion.Builder)RedshiftScopeUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceIntegrationUnion build() {
            return new ServiceIntegrationUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceIntegrationUnion> {
        public Builder redshift(Collection<RedshiftScopeUnion> var1);

        public Builder redshift(RedshiftScopeUnion ... var1);

        public Builder redshift(Consumer<RedshiftScopeUnion.Builder> ... var1);
    }
}

