/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.TransactionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommitTransactionResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, CommitTransactionResponse> {
    private static final SdkField<String> TRANSACTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionStatus").getter(CommitTransactionResponse.getter(CommitTransactionResponse::transactionStatusAsString)).setter(CommitTransactionResponse.setter(Builder::transactionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransactionStatus", TRANSACTION_STATUS_FIELD);
        }
    });
    private final String transactionStatus;

    private CommitTransactionResponse(BuilderImpl builder) {
        super(builder);
        this.transactionStatus = builder.transactionStatus;
    }

    public final TransactionStatus transactionStatus() {
        return TransactionStatus.fromValue(this.transactionStatus);
    }

    public final String transactionStatusAsString() {
        return this.transactionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitTransactionResponse)) {
            return false;
        }
        CommitTransactionResponse other = (CommitTransactionResponse)((Object)obj);
        return Objects.equals(this.transactionStatusAsString(), other.transactionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CommitTransactionResponse").add("TransactionStatus", (Object)this.transactionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransactionStatus": {
                return Optional.ofNullable(clazz.cast(this.transactionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CommitTransactionResponse, T> g) {
        return obj -> g.apply((CommitTransactionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private String transactionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitTransactionResponse model) {
            super(model);
            this.transactionStatus(model.transactionStatus);
        }

        public final String getTransactionStatus() {
            return this.transactionStatus;
        }

        public final void setTransactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        @Override
        public final Builder transactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
            return this;
        }

        @Override
        public final Builder transactionStatus(TransactionStatus transactionStatus) {
            this.transactionStatus(transactionStatus == null ? null : transactionStatus.toString());
            return this;
        }

        @Override
        public CommitTransactionResponse build() {
            return new CommitTransactionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CommitTransactionResponse> {
        public Builder transactionStatus(String var1);

        public Builder transactionStatus(TransactionStatus var1);
    }
}

