/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceInfo> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ResourceInfo.getter(ResourceInfo::resourceArn)).setter(ResourceInfo.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ResourceInfo.getter(ResourceInfo::roleArn)).setter(ResourceInfo.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(ResourceInfo.getter(ResourceInfo::lastModified)).setter(ResourceInfo.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<Boolean> WITH_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WithFederation").getter(ResourceInfo.getter(ResourceInfo::withFederation)).setter(ResourceInfo.setter(Builder::withFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithFederation").build()}).build();
    private static final SdkField<Boolean> HYBRID_ACCESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HybridAccessEnabled").getter(ResourceInfo.getter(ResourceInfo::hybridAccessEnabled)).setter(ResourceInfo.setter(Builder::hybridAccessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HybridAccessEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, ROLE_ARN_FIELD, LAST_MODIFIED_FIELD, WITH_FEDERATION_FIELD, HYBRID_ACCESS_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String roleArn;
    private final Instant lastModified;
    private final Boolean withFederation;
    private final Boolean hybridAccessEnabled;

    private ResourceInfo(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.roleArn = builder.roleArn;
        this.lastModified = builder.lastModified;
        this.withFederation = builder.withFederation;
        this.hybridAccessEnabled = builder.hybridAccessEnabled;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final Boolean withFederation() {
        return this.withFederation;
    }

    public final Boolean hybridAccessEnabled() {
        return this.hybridAccessEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.withFederation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hybridAccessEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceInfo)) {
            return false;
        }
        ResourceInfo other = (ResourceInfo)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.withFederation(), other.withFederation()) && Objects.equals(this.hybridAccessEnabled(), other.hybridAccessEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceInfo").add("ResourceArn", (Object)this.resourceArn()).add("RoleArn", (Object)this.roleArn()).add("LastModified", (Object)this.lastModified()).add("WithFederation", (Object)this.withFederation()).add("HybridAccessEnabled", (Object)this.hybridAccessEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "WithFederation": {
                return Optional.ofNullable(clazz.cast(this.withFederation()));
            }
            case "HybridAccessEnabled": {
                return Optional.ofNullable(clazz.cast(this.hybridAccessEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceInfo, T> g) {
        return obj -> g.apply((ResourceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String roleArn;
        private Instant lastModified;
        private Boolean withFederation;
        private Boolean hybridAccessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInfo model) {
            this.resourceArn(model.resourceArn);
            this.roleArn(model.roleArn);
            this.lastModified(model.lastModified);
            this.withFederation(model.withFederation);
            this.hybridAccessEnabled(model.hybridAccessEnabled);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Boolean getWithFederation() {
            return this.withFederation;
        }

        public final void setWithFederation(Boolean withFederation) {
            this.withFederation = withFederation;
        }

        @Override
        public final Builder withFederation(Boolean withFederation) {
            this.withFederation = withFederation;
            return this;
        }

        public final Boolean getHybridAccessEnabled() {
            return this.hybridAccessEnabled;
        }

        public final void setHybridAccessEnabled(Boolean hybridAccessEnabled) {
            this.hybridAccessEnabled = hybridAccessEnabled;
        }

        @Override
        public final Builder hybridAccessEnabled(Boolean hybridAccessEnabled) {
            this.hybridAccessEnabled = hybridAccessEnabled;
            return this;
        }

        public ResourceInfo build() {
            return new ResourceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceInfo> {
        public Builder resourceArn(String var1);

        public Builder roleArn(String var1);

        public Builder lastModified(Instant var1);

        public Builder withFederation(Boolean var1);

        public Builder hybridAccessEnabled(Boolean var1);
    }
}

