/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.PartitionValuesListCopier;
import software.amazon.awssdk.services.lakeformation.model.TableObject;
import software.amazon.awssdk.services.lakeformation.model.TableObjectListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartitionObjects
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartitionObjects> {
    private static final SdkField<List<String>> PARTITION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionValues").getter(PartitionObjects.getter(PartitionObjects::partitionValues)).setter(PartitionObjects.setter(Builder::partitionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TableObject>> OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Objects").getter(PartitionObjects.getter(PartitionObjects::objects)).setter(PartitionObjects.setter(Builder::objects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_VALUES_FIELD, OBJECTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> partitionValues;
    private final List<TableObject> objects;

    private PartitionObjects(BuilderImpl builder) {
        this.partitionValues = builder.partitionValues;
        this.objects = builder.objects;
    }

    public final boolean hasPartitionValues() {
        return this.partitionValues != null && !(this.partitionValues instanceof SdkAutoConstructList);
    }

    public final List<String> partitionValues() {
        return this.partitionValues;
    }

    public final boolean hasObjects() {
        return this.objects != null && !(this.objects instanceof SdkAutoConstructList);
    }

    public final List<TableObject> objects() {
        return this.objects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionValues() ? this.partitionValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjects() ? this.objects() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionObjects)) {
            return false;
        }
        PartitionObjects other = (PartitionObjects)obj;
        return this.hasPartitionValues() == other.hasPartitionValues() && Objects.equals(this.partitionValues(), other.partitionValues()) && this.hasObjects() == other.hasObjects() && Objects.equals(this.objects(), other.objects());
    }

    public final String toString() {
        return ToString.builder((String)"PartitionObjects").add("PartitionValues", this.hasPartitionValues() ? this.partitionValues() : null).add("Objects", this.hasObjects() ? this.objects() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionValues": {
                return Optional.ofNullable(clazz.cast(this.partitionValues()));
            }
            case "Objects": {
                return Optional.ofNullable(clazz.cast(this.objects()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartitionObjects, T> g) {
        return obj -> g.apply((PartitionObjects)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> partitionValues = DefaultSdkAutoConstructList.getInstance();
        private List<TableObject> objects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionObjects model) {
            this.partitionValues(model.partitionValues);
            this.objects(model.objects);
        }

        public final Collection<String> getPartitionValues() {
            if (this.partitionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionValues;
        }

        public final void setPartitionValues(Collection<String> partitionValues) {
            this.partitionValues = PartitionValuesListCopier.copy(partitionValues);
        }

        @Override
        public final Builder partitionValues(Collection<String> partitionValues) {
            this.partitionValues = PartitionValuesListCopier.copy(partitionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValues(String ... partitionValues) {
            this.partitionValues(Arrays.asList(partitionValues));
            return this;
        }

        public final List<TableObject.Builder> getObjects() {
            List<TableObject.Builder> result = TableObjectListCopier.copyToBuilder(this.objects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjects(Collection<TableObject.BuilderImpl> objects) {
            this.objects = TableObjectListCopier.copyFromBuilder(objects);
        }

        @Override
        public final Builder objects(Collection<TableObject> objects) {
            this.objects = TableObjectListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(TableObject ... objects) {
            this.objects(Arrays.asList(objects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(Consumer<TableObject.Builder> ... objects) {
            this.objects(Stream.of(objects).map(c -> (TableObject)((TableObject.Builder)TableObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PartitionObjects build() {
            return new PartitionObjects(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartitionObjects> {
        public Builder partitionValues(Collection<String> var1);

        public Builder partitionValues(String ... var1);

        public Builder objects(Collection<TableObject> var1);

        public Builder objects(TableObject ... var1);

        public Builder objects(Consumer<TableObject.Builder> ... var1);
    }
}

