/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.services.lakeformation.model.TagValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLfTagRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, UpdateLfTagRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(UpdateLfTagRequest.getter(UpdateLfTagRequest::catalogId)).setter(UpdateLfTagRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagKey").getter(UpdateLfTagRequest.getter(UpdateLfTagRequest::tagKey)).setter(UpdateLfTagRequest.setter(Builder::tagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()}).build();
    private static final SdkField<List<String>> TAG_VALUES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagValuesToDelete").getter(UpdateLfTagRequest.getter(UpdateLfTagRequest::tagValuesToDelete)).setter(UpdateLfTagRequest.setter(Builder::tagValuesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValuesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_VALUES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagValuesToAdd").getter(UpdateLfTagRequest.getter(UpdateLfTagRequest::tagValuesToAdd)).setter(UpdateLfTagRequest.setter(Builder::tagValuesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValuesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, TAG_KEY_FIELD, TAG_VALUES_TO_DELETE_FIELD, TAG_VALUES_TO_ADD_FIELD));
    private final String catalogId;
    private final String tagKey;
    private final List<String> tagValuesToDelete;
    private final List<String> tagValuesToAdd;

    private UpdateLfTagRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.tagKey = builder.tagKey;
        this.tagValuesToDelete = builder.tagValuesToDelete;
        this.tagValuesToAdd = builder.tagValuesToAdd;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String tagKey() {
        return this.tagKey;
    }

    public final boolean hasTagValuesToDelete() {
        return this.tagValuesToDelete != null && !(this.tagValuesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> tagValuesToDelete() {
        return this.tagValuesToDelete;
    }

    public final boolean hasTagValuesToAdd() {
        return this.tagValuesToAdd != null && !(this.tagValuesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> tagValuesToAdd() {
        return this.tagValuesToAdd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagValuesToDelete() ? this.tagValuesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagValuesToAdd() ? this.tagValuesToAdd() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLfTagRequest)) {
            return false;
        }
        UpdateLfTagRequest other = (UpdateLfTagRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.tagKey(), other.tagKey()) && this.hasTagValuesToDelete() == other.hasTagValuesToDelete() && Objects.equals(this.tagValuesToDelete(), other.tagValuesToDelete()) && this.hasTagValuesToAdd() == other.hasTagValuesToAdd() && Objects.equals(this.tagValuesToAdd(), other.tagValuesToAdd());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLfTagRequest").add("CatalogId", (Object)this.catalogId()).add("TagKey", (Object)this.tagKey()).add("TagValuesToDelete", this.hasTagValuesToDelete() ? this.tagValuesToDelete() : null).add("TagValuesToAdd", this.hasTagValuesToAdd() ? this.tagValuesToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "TagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "TagValuesToDelete": {
                return Optional.ofNullable(clazz.cast(this.tagValuesToDelete()));
            }
            case "TagValuesToAdd": {
                return Optional.ofNullable(clazz.cast(this.tagValuesToAdd()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLfTagRequest, T> g) {
        return obj -> g.apply((UpdateLfTagRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String tagKey;
        private List<String> tagValuesToDelete = DefaultSdkAutoConstructList.getInstance();
        private List<String> tagValuesToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLfTagRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.tagKey(model.tagKey);
            this.tagValuesToDelete(model.tagValuesToDelete);
            this.tagValuesToAdd(model.tagValuesToAdd);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final Collection<String> getTagValuesToDelete() {
            if (this.tagValuesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagValuesToDelete;
        }

        public final void setTagValuesToDelete(Collection<String> tagValuesToDelete) {
            this.tagValuesToDelete = TagValueListCopier.copy(tagValuesToDelete);
        }

        @Override
        public final Builder tagValuesToDelete(Collection<String> tagValuesToDelete) {
            this.tagValuesToDelete = TagValueListCopier.copy(tagValuesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValuesToDelete(String ... tagValuesToDelete) {
            this.tagValuesToDelete(Arrays.asList(tagValuesToDelete));
            return this;
        }

        public final Collection<String> getTagValuesToAdd() {
            if (this.tagValuesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagValuesToAdd;
        }

        public final void setTagValuesToAdd(Collection<String> tagValuesToAdd) {
            this.tagValuesToAdd = TagValueListCopier.copy(tagValuesToAdd);
        }

        @Override
        public final Builder tagValuesToAdd(Collection<String> tagValuesToAdd) {
            this.tagValuesToAdd = TagValueListCopier.copy(tagValuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValuesToAdd(String ... tagValuesToAdd) {
            this.tagValuesToAdd(Arrays.asList(tagValuesToAdd));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLfTagRequest build() {
            return new UpdateLfTagRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLfTagRequest> {
        public Builder catalogId(String var1);

        public Builder tagKey(String var1);

        public Builder tagValuesToDelete(Collection<String> var1);

        public Builder tagValuesToDelete(String ... var1);

        public Builder tagValuesToAdd(Collection<String> var1);

        public Builder tagValuesToAdd(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

