/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.CatalogResource;
import software.amazon.awssdk.services.lakeformation.model.DataLocationResource;
import software.amazon.awssdk.services.lakeformation.model.DatabaseResource;
import software.amazon.awssdk.services.lakeformation.model.TableResource;
import software.amazon.awssdk.services.lakeformation.model.TableWithColumnsResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<CatalogResource> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Resource.getter(Resource::catalog)).setter(Resource.setter(Builder::catalog)).constructor(CatalogResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<DatabaseResource> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Resource.getter(Resource::database)).setter(Resource.setter(Builder::database)).constructor(DatabaseResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<TableResource> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Resource.getter(Resource::table)).setter(Resource.setter(Builder::table)).constructor(TableResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<TableWithColumnsResource> TABLE_WITH_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Resource.getter(Resource::tableWithColumns)).setter(Resource.setter(Builder::tableWithColumns)).constructor(TableWithColumnsResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableWithColumns").build()}).build();
    private static final SdkField<DataLocationResource> DATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Resource.getter(Resource::dataLocation)).setter(Resource.setter(Builder::dataLocation)).constructor(DataLocationResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, DATABASE_FIELD, TABLE_FIELD, TABLE_WITH_COLUMNS_FIELD, DATA_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final CatalogResource catalog;
    private final DatabaseResource database;
    private final TableResource table;
    private final TableWithColumnsResource tableWithColumns;
    private final DataLocationResource dataLocation;

    private Resource(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.database = builder.database;
        this.table = builder.table;
        this.tableWithColumns = builder.tableWithColumns;
        this.dataLocation = builder.dataLocation;
    }

    public CatalogResource catalog() {
        return this.catalog;
    }

    public DatabaseResource database() {
        return this.database;
    }

    public TableResource table() {
        return this.table;
    }

    public TableWithColumnsResource tableWithColumns() {
        return this.tableWithColumns;
    }

    public DataLocationResource dataLocation() {
        return this.dataLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableWithColumns());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.tableWithColumns(), other.tableWithColumns()) && Objects.equals(this.dataLocation(), other.dataLocation());
    }

    public String toString() {
        return ToString.builder((String)"Resource").add("Catalog", (Object)this.catalog()).add("Database", (Object)this.database()).add("Table", (Object)this.table()).add("TableWithColumns", (Object)this.tableWithColumns()).add("DataLocation", (Object)this.dataLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "TableWithColumns": {
                return Optional.ofNullable(clazz.cast(this.tableWithColumns()));
            }
            case "DataLocation": {
                return Optional.ofNullable(clazz.cast(this.dataLocation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CatalogResource catalog;
        private DatabaseResource database;
        private TableResource table;
        private TableWithColumnsResource tableWithColumns;
        private DataLocationResource dataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.catalog(model.catalog);
            this.database(model.database);
            this.table(model.table);
            this.tableWithColumns(model.tableWithColumns);
            this.dataLocation(model.dataLocation);
        }

        public final CatalogResource.Builder getCatalog() {
            return this.catalog != null ? this.catalog.toBuilder() : null;
        }

        @Override
        public final Builder catalog(CatalogResource catalog) {
            this.catalog = catalog;
            return this;
        }

        public final void setCatalog(CatalogResource.BuilderImpl catalog) {
            this.catalog = catalog != null ? catalog.build() : null;
        }

        public final DatabaseResource.Builder getDatabase() {
            return this.database != null ? this.database.toBuilder() : null;
        }

        @Override
        public final Builder database(DatabaseResource database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(DatabaseResource.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        public final TableResource.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        @Override
        public final Builder table(TableResource table) {
            this.table = table;
            return this;
        }

        public final void setTable(TableResource.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        public final TableWithColumnsResource.Builder getTableWithColumns() {
            return this.tableWithColumns != null ? this.tableWithColumns.toBuilder() : null;
        }

        @Override
        public final Builder tableWithColumns(TableWithColumnsResource tableWithColumns) {
            this.tableWithColumns = tableWithColumns;
            return this;
        }

        public final void setTableWithColumns(TableWithColumnsResource.BuilderImpl tableWithColumns) {
            this.tableWithColumns = tableWithColumns != null ? tableWithColumns.build() : null;
        }

        public final DataLocationResource.Builder getDataLocation() {
            return this.dataLocation != null ? this.dataLocation.toBuilder() : null;
        }

        @Override
        public final Builder dataLocation(DataLocationResource dataLocation) {
            this.dataLocation = dataLocation;
            return this;
        }

        public final void setDataLocation(DataLocationResource.BuilderImpl dataLocation) {
            this.dataLocation = dataLocation != null ? dataLocation.build() : null;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder catalog(CatalogResource var1);

        default public Builder catalog(Consumer<CatalogResource.Builder> catalog) {
            return this.catalog((CatalogResource)((CatalogResource.Builder)CatalogResource.builder().applyMutation(catalog)).build());
        }

        public Builder database(DatabaseResource var1);

        default public Builder database(Consumer<DatabaseResource.Builder> database) {
            return this.database((DatabaseResource)((DatabaseResource.Builder)DatabaseResource.builder().applyMutation(database)).build());
        }

        public Builder table(TableResource var1);

        default public Builder table(Consumer<TableResource.Builder> table) {
            return this.table((TableResource)((TableResource.Builder)TableResource.builder().applyMutation(table)).build());
        }

        public Builder tableWithColumns(TableWithColumnsResource var1);

        default public Builder tableWithColumns(Consumer<TableWithColumnsResource.Builder> tableWithColumns) {
            return this.tableWithColumns((TableWithColumnsResource)((TableWithColumnsResource.Builder)TableWithColumnsResource.builder().applyMutation(tableWithColumns)).build());
        }

        public Builder dataLocation(DataLocationResource var1);

        default public Builder dataLocation(Consumer<DataLocationResource.Builder> dataLocation) {
            return this.dataLocation((DataLocationResource)((DataLocationResource.Builder)DataLocationResource.builder().applyMutation(dataLocation)).build());
        }
    }
}

