/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum GrantOperation {
    DECRYPT("Decrypt"),
    ENCRYPT("Encrypt"),
    GENERATE_DATA_KEY("GenerateDataKey"),
    GENERATE_DATA_KEY_WITHOUT_PLAINTEXT("GenerateDataKeyWithoutPlaintext"),
    RE_ENCRYPT_FROM("ReEncryptFrom"),
    RE_ENCRYPT_TO("ReEncryptTo"),
    CREATE_GRANT("CreateGrant"),
    RETIRE_GRANT("RetireGrant"),
    DESCRIBE_KEY("DescribeKey"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private GrantOperation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GrantOperation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(GrantOperation.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GrantOperation> knownValues() {
        return Stream.of(GrantOperation.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

