/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each entry contains information about one of the key materials associated with a KMS key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotationsListEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<RotationsListEntry.Builder, RotationsListEntry> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyId")
            .getter(getter(RotationsListEntry::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> KEY_MATERIAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyMaterialId").getter(getter(RotationsListEntry::keyMaterialId)).setter(setter(Builder::keyMaterialId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialId").build()).build();

    private static final SdkField<String> KEY_MATERIAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyMaterialDescription").getter(getter(RotationsListEntry::keyMaterialDescription))
            .setter(setter(Builder::keyMaterialDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialDescription").build())
            .build();

    private static final SdkField<String> IMPORT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportState").getter(getter(RotationsListEntry::importStateAsString))
            .setter(setter(Builder::importState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportState").build()).build();

    private static final SdkField<String> KEY_MATERIAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyMaterialState").getter(getter(RotationsListEntry::keyMaterialStateAsString))
            .setter(setter(Builder::keyMaterialState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialState").build()).build();

    private static final SdkField<String> EXPIRATION_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationModel").getter(getter(RotationsListEntry::expirationModelAsString))
            .setter(setter(Builder::expirationModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationModel").build()).build();

    private static final SdkField<Instant> VALID_TO_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidTo").getter(getter(RotationsListEntry::validTo)).setter(setter(Builder::validTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidTo").build()).build();

    private static final SdkField<Instant> ROTATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RotationDate").getter(getter(RotationsListEntry::rotationDate)).setter(setter(Builder::rotationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationDate").build()).build();

    private static final SdkField<String> ROTATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationType").getter(getter(RotationsListEntry::rotationTypeAsString))
            .setter(setter(Builder::rotationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD,
            KEY_MATERIAL_ID_FIELD, KEY_MATERIAL_DESCRIPTION_FIELD, IMPORT_STATE_FIELD, KEY_MATERIAL_STATE_FIELD,
            EXPIRATION_MODEL_FIELD, VALID_TO_FIELD, ROTATION_DATE_FIELD, ROTATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyId;

    private final String keyMaterialId;

    private final String keyMaterialDescription;

    private final String importState;

    private final String keyMaterialState;

    private final String expirationModel;

    private final Instant validTo;

    private final Instant rotationDate;

    private final String rotationType;

    private RotationsListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.keyMaterialId = builder.keyMaterialId;
        this.keyMaterialDescription = builder.keyMaterialDescription;
        this.importState = builder.importState;
        this.keyMaterialState = builder.keyMaterialState;
        this.expirationModel = builder.expirationModel;
        this.validTo = builder.validTo;
        this.rotationDate = builder.rotationDate;
        this.rotationType = builder.rotationType;
    }

    /**
     * <p>
     * Unique identifier of the key.
     * </p>
     * 
     * @return Unique identifier of the key.
     */
    public final String keyId() {
        return keyId;
    }

    /**
     * <p>
     * Unique identifier of the key material.
     * </p>
     * 
     * @return Unique identifier of the key material.
     */
    public final String keyMaterialId() {
        return keyMaterialId;
    }

    /**
     * <p>
     * User-specified description of the key material. This field is only present for symmetric encryption KMS keys with
     * <code>EXTERNAL</code> origin.
     * </p>
     * 
     * @return User-specified description of the key material. This field is only present for symmetric encryption KMS
     *         keys with <code>EXTERNAL</code> origin.
     */
    public final String keyMaterialDescription() {
        return keyMaterialDescription;
    }

    /**
     * <p>
     * Indicates if the key material is currently imported into KMS. It has two possible values: <code>IMPORTED</code>
     * or <code>PENDING_IMPORT</code>. This field is only present for symmetric encryption KMS keys with
     * <code>EXTERNAL</code> origin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importState} will
     * return {@link ImportState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStateAsString}.
     * </p>
     * 
     * @return Indicates if the key material is currently imported into KMS. It has two possible values:
     *         <code>IMPORTED</code> or <code>PENDING_IMPORT</code>. This field is only present for symmetric encryption
     *         KMS keys with <code>EXTERNAL</code> origin.
     * @see ImportState
     */
    public final ImportState importState() {
        return ImportState.fromValue(importState);
    }

    /**
     * <p>
     * Indicates if the key material is currently imported into KMS. It has two possible values: <code>IMPORTED</code>
     * or <code>PENDING_IMPORT</code>. This field is only present for symmetric encryption KMS keys with
     * <code>EXTERNAL</code> origin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importState} will
     * return {@link ImportState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStateAsString}.
     * </p>
     * 
     * @return Indicates if the key material is currently imported into KMS. It has two possible values:
     *         <code>IMPORTED</code> or <code>PENDING_IMPORT</code>. This field is only present for symmetric encryption
     *         KMS keys with <code>EXTERNAL</code> origin.
     * @see ImportState
     */
    public final String importStateAsString() {
        return importState;
    }

    /**
     * <p>
     * There are four possible values for this field: <code>CURRENT</code>, <code>NON_CURRENT</code>,
     * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>. KMS uses
     * <code>CURRENT</code> key material for both encryption and decryption and <code>NON_CURRENT</code> key material
     * only for decryption. <code>PENDING_ROTATION</code> identifies key material that has been imported for on-demand
     * key rotation but the rotation hasn't completed. The key material state
     * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> is unique to multi-region, symmetric encryption keys with
     * imported key material. It indicates key material that has been imported into the primary Region key but not all
     * of the replica Region keys. When this key material is imported in to all of the replica Region keys, the key
     * material state will change to <code>PENDING_ROTATION</code>. Key material in
     * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> or <code>PENDING_ROTATION</code> state is not permanently
     * associated with the KMS key. You can delete this key material and import different key material in its place. The
     * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code> values are only used in
     * symmetric encryption keys with imported key material. The other values, <code>CURRENT</code> and
     * <code>NON_CURRENT</code>, are used for all KMS keys that support automatic or on-demand key rotation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyMaterialState}
     * will return {@link KeyMaterialState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyMaterialStateAsString}.
     * </p>
     * 
     * @return There are four possible values for this field: <code>CURRENT</code>, <code>NON_CURRENT</code>,
     *         <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>. KMS uses
     *         <code>CURRENT</code> key material for both encryption and decryption and <code>NON_CURRENT</code> key
     *         material only for decryption. <code>PENDING_ROTATION</code> identifies key material that has been
     *         imported for on-demand key rotation but the rotation hasn't completed. The key material state
     *         <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> is unique to multi-region, symmetric encryption
     *         keys with imported key material. It indicates key material that has been imported into the primary Region
     *         key but not all of the replica Region keys. When this key material is imported in to all of the replica
     *         Region keys, the key material state will change to <code>PENDING_ROTATION</code>. Key material in
     *         <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> or <code>PENDING_ROTATION</code> state is not
     *         permanently associated with the KMS key. You can delete this key material and import different key
     *         material in its place. The <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and
     *         <code>PENDING_ROTATION</code> values are only used in symmetric encryption keys with imported key
     *         material. The other values, <code>CURRENT</code> and <code>NON_CURRENT</code>, are used for all KMS keys
     *         that support automatic or on-demand key rotation.
     * @see KeyMaterialState
     */
    public final KeyMaterialState keyMaterialState() {
        return KeyMaterialState.fromValue(keyMaterialState);
    }

    /**
     * <p>
     * There are four possible values for this field: <code>CURRENT</code>, <code>NON_CURRENT</code>,
     * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>. KMS uses
     * <code>CURRENT</code> key material for both encryption and decryption and <code>NON_CURRENT</code> key material
     * only for decryption. <code>PENDING_ROTATION</code> identifies key material that has been imported for on-demand
     * key rotation but the rotation hasn't completed. The key material state
     * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> is unique to multi-region, symmetric encryption keys with
     * imported key material. It indicates key material that has been imported into the primary Region key but not all
     * of the replica Region keys. When this key material is imported in to all of the replica Region keys, the key
     * material state will change to <code>PENDING_ROTATION</code>. Key material in
     * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> or <code>PENDING_ROTATION</code> state is not permanently
     * associated with the KMS key. You can delete this key material and import different key material in its place. The
     * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code> values are only used in
     * symmetric encryption keys with imported key material. The other values, <code>CURRENT</code> and
     * <code>NON_CURRENT</code>, are used for all KMS keys that support automatic or on-demand key rotation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyMaterialState}
     * will return {@link KeyMaterialState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyMaterialStateAsString}.
     * </p>
     * 
     * @return There are four possible values for this field: <code>CURRENT</code>, <code>NON_CURRENT</code>,
     *         <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>. KMS uses
     *         <code>CURRENT</code> key material for both encryption and decryption and <code>NON_CURRENT</code> key
     *         material only for decryption. <code>PENDING_ROTATION</code> identifies key material that has been
     *         imported for on-demand key rotation but the rotation hasn't completed. The key material state
     *         <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> is unique to multi-region, symmetric encryption
     *         keys with imported key material. It indicates key material that has been imported into the primary Region
     *         key but not all of the replica Region keys. When this key material is imported in to all of the replica
     *         Region keys, the key material state will change to <code>PENDING_ROTATION</code>. Key material in
     *         <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> or <code>PENDING_ROTATION</code> state is not
     *         permanently associated with the KMS key. You can delete this key material and import different key
     *         material in its place. The <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and
     *         <code>PENDING_ROTATION</code> values are only used in symmetric encryption keys with imported key
     *         material. The other values, <code>CURRENT</code> and <code>NON_CURRENT</code>, are used for all KMS keys
     *         that support automatic or on-demand key rotation.
     * @see KeyMaterialState
     */
    public final String keyMaterialStateAsString() {
        return keyMaterialState;
    }

    /**
     * <p>
     * Indicates if the key material is configured to automatically expire. There are two possible values for this
     * field: <code>KEY_MATERIAL_EXPIRES</code> and <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. For any key material that
     * expires, the expiration date and time is indicated in <code>ValidTo</code>. This field is only present for
     * symmetric encryption KMS keys with <code>EXTERNAL</code> origin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #expirationModel}
     * will return {@link ExpirationModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #expirationModelAsString}.
     * </p>
     * 
     * @return Indicates if the key material is configured to automatically expire. There are two possible values for
     *         this field: <code>KEY_MATERIAL_EXPIRES</code> and <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. For any key
     *         material that expires, the expiration date and time is indicated in <code>ValidTo</code>. This field is
     *         only present for symmetric encryption KMS keys with <code>EXTERNAL</code> origin.
     * @see ExpirationModelType
     */
    public final ExpirationModelType expirationModel() {
        return ExpirationModelType.fromValue(expirationModel);
    }

    /**
     * <p>
     * Indicates if the key material is configured to automatically expire. There are two possible values for this
     * field: <code>KEY_MATERIAL_EXPIRES</code> and <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. For any key material that
     * expires, the expiration date and time is indicated in <code>ValidTo</code>. This field is only present for
     * symmetric encryption KMS keys with <code>EXTERNAL</code> origin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #expirationModel}
     * will return {@link ExpirationModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #expirationModelAsString}.
     * </p>
     * 
     * @return Indicates if the key material is configured to automatically expire. There are two possible values for
     *         this field: <code>KEY_MATERIAL_EXPIRES</code> and <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. For any key
     *         material that expires, the expiration date and time is indicated in <code>ValidTo</code>. This field is
     *         only present for symmetric encryption KMS keys with <code>EXTERNAL</code> origin.
     * @see ExpirationModelType
     */
    public final String expirationModelAsString() {
        return expirationModel;
    }

    /**
     * <p>
     * Date and time at which the key material expires. This field is only present for symmetric encryption KMS keys
     * with <code>EXTERNAL</code> origin in rotation list entries with an <code>ExpirationModel</code> value of
     * <code>KEY_MATERIAL_EXPIRES</code>.
     * </p>
     * 
     * @return Date and time at which the key material expires. This field is only present for symmetric encryption KMS
     *         keys with <code>EXTERNAL</code> origin in rotation list entries with an <code>ExpirationModel</code>
     *         value of <code>KEY_MATERIAL_EXPIRES</code>.
     */
    public final Instant validTo() {
        return validTo;
    }

    /**
     * <p>
     * Date and time that the key material rotation completed. Formatted as Unix time. This field is not present for the
     * first key material or an imported key material in <code>PENDING_ROTATION</code> state.
     * </p>
     * 
     * @return Date and time that the key material rotation completed. Formatted as Unix time. This field is not present
     *         for the first key material or an imported key material in <code>PENDING_ROTATION</code> state.
     */
    public final Instant rotationDate() {
        return rotationDate;
    }

    /**
     * <p>
     * Identifies whether the key material rotation was a scheduled <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html">automatic
     * rotation</a> or an <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html">on-demand rotation</a>.
     * This field is not present for the first key material or an imported key material in <code>PENDING_ROTATION</code>
     * state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rotationType} will
     * return {@link RotationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rotationTypeAsString}.
     * </p>
     * 
     * @return Identifies whether the key material rotation was a scheduled <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html">automatic
     *         rotation</a> or an <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html">on-demand
     *         rotation</a>. This field is not present for the first key material or an imported key material in
     *         <code>PENDING_ROTATION</code> state.
     * @see RotationType
     */
    public final RotationType rotationType() {
        return RotationType.fromValue(rotationType);
    }

    /**
     * <p>
     * Identifies whether the key material rotation was a scheduled <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html">automatic
     * rotation</a> or an <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html">on-demand rotation</a>.
     * This field is not present for the first key material or an imported key material in <code>PENDING_ROTATION</code>
     * state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rotationType} will
     * return {@link RotationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rotationTypeAsString}.
     * </p>
     * 
     * @return Identifies whether the key material rotation was a scheduled <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html">automatic
     *         rotation</a> or an <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html">on-demand
     *         rotation</a>. This field is not present for the first key material or an imported key material in
     *         <code>PENDING_ROTATION</code> state.
     * @see RotationType
     */
    public final String rotationTypeAsString() {
        return rotationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(keyMaterialId());
        hashCode = 31 * hashCode + Objects.hashCode(keyMaterialDescription());
        hashCode = 31 * hashCode + Objects.hashCode(importStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyMaterialStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expirationModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validTo());
        hashCode = 31 * hashCode + Objects.hashCode(rotationDate());
        hashCode = 31 * hashCode + Objects.hashCode(rotationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationsListEntry)) {
            return false;
        }
        RotationsListEntry other = (RotationsListEntry) obj;
        return Objects.equals(keyId(), other.keyId()) && Objects.equals(keyMaterialId(), other.keyMaterialId())
                && Objects.equals(keyMaterialDescription(), other.keyMaterialDescription())
                && Objects.equals(importStateAsString(), other.importStateAsString())
                && Objects.equals(keyMaterialStateAsString(), other.keyMaterialStateAsString())
                && Objects.equals(expirationModelAsString(), other.expirationModelAsString())
                && Objects.equals(validTo(), other.validTo()) && Objects.equals(rotationDate(), other.rotationDate())
                && Objects.equals(rotationTypeAsString(), other.rotationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RotationsListEntry").add("KeyId", keyId()).add("KeyMaterialId", keyMaterialId())
                .add("KeyMaterialDescription", keyMaterialDescription()).add("ImportState", importStateAsString())
                .add("KeyMaterialState", keyMaterialStateAsString()).add("ExpirationModel", expirationModelAsString())
                .add("ValidTo", validTo()).add("RotationDate", rotationDate()).add("RotationType", rotationTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "KeyMaterialId":
            return Optional.ofNullable(clazz.cast(keyMaterialId()));
        case "KeyMaterialDescription":
            return Optional.ofNullable(clazz.cast(keyMaterialDescription()));
        case "ImportState":
            return Optional.ofNullable(clazz.cast(importStateAsString()));
        case "KeyMaterialState":
            return Optional.ofNullable(clazz.cast(keyMaterialStateAsString()));
        case "ExpirationModel":
            return Optional.ofNullable(clazz.cast(expirationModelAsString()));
        case "ValidTo":
            return Optional.ofNullable(clazz.cast(validTo()));
        case "RotationDate":
            return Optional.ofNullable(clazz.cast(rotationDate()));
        case "RotationType":
            return Optional.ofNullable(clazz.cast(rotationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("KeyMaterialId", KEY_MATERIAL_ID_FIELD);
        map.put("KeyMaterialDescription", KEY_MATERIAL_DESCRIPTION_FIELD);
        map.put("ImportState", IMPORT_STATE_FIELD);
        map.put("KeyMaterialState", KEY_MATERIAL_STATE_FIELD);
        map.put("ExpirationModel", EXPIRATION_MODEL_FIELD);
        map.put("ValidTo", VALID_TO_FIELD);
        map.put("RotationDate", ROTATION_DATE_FIELD);
        map.put("RotationType", ROTATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotationsListEntry, T> g) {
        return obj -> g.apply((RotationsListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RotationsListEntry> {
        /**
         * <p>
         * Unique identifier of the key.
         * </p>
         * 
         * @param keyId
         *        Unique identifier of the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * Unique identifier of the key material.
         * </p>
         * 
         * @param keyMaterialId
         *        Unique identifier of the key material.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMaterialId(String keyMaterialId);

        /**
         * <p>
         * User-specified description of the key material. This field is only present for symmetric encryption KMS keys
         * with <code>EXTERNAL</code> origin.
         * </p>
         * 
         * @param keyMaterialDescription
         *        User-specified description of the key material. This field is only present for symmetric encryption
         *        KMS keys with <code>EXTERNAL</code> origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMaterialDescription(String keyMaterialDescription);

        /**
         * <p>
         * Indicates if the key material is currently imported into KMS. It has two possible values:
         * <code>IMPORTED</code> or <code>PENDING_IMPORT</code>. This field is only present for symmetric encryption KMS
         * keys with <code>EXTERNAL</code> origin.
         * </p>
         * 
         * @param importState
         *        Indicates if the key material is currently imported into KMS. It has two possible values:
         *        <code>IMPORTED</code> or <code>PENDING_IMPORT</code>. This field is only present for symmetric
         *        encryption KMS keys with <code>EXTERNAL</code> origin.
         * @see ImportState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportState
         */
        Builder importState(String importState);

        /**
         * <p>
         * Indicates if the key material is currently imported into KMS. It has two possible values:
         * <code>IMPORTED</code> or <code>PENDING_IMPORT</code>. This field is only present for symmetric encryption KMS
         * keys with <code>EXTERNAL</code> origin.
         * </p>
         * 
         * @param importState
         *        Indicates if the key material is currently imported into KMS. It has two possible values:
         *        <code>IMPORTED</code> or <code>PENDING_IMPORT</code>. This field is only present for symmetric
         *        encryption KMS keys with <code>EXTERNAL</code> origin.
         * @see ImportState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportState
         */
        Builder importState(ImportState importState);

        /**
         * <p>
         * There are four possible values for this field: <code>CURRENT</code>, <code>NON_CURRENT</code>,
         * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>. KMS uses
         * <code>CURRENT</code> key material for both encryption and decryption and <code>NON_CURRENT</code> key
         * material only for decryption. <code>PENDING_ROTATION</code> identifies key material that has been imported
         * for on-demand key rotation but the rotation hasn't completed. The key material state
         * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> is unique to multi-region, symmetric encryption keys
         * with imported key material. It indicates key material that has been imported into the primary Region key but
         * not all of the replica Region keys. When this key material is imported in to all of the replica Region keys,
         * the key material state will change to <code>PENDING_ROTATION</code>. Key material in
         * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> or <code>PENDING_ROTATION</code> state is not
         * permanently associated with the KMS key. You can delete this key material and import different key material
         * in its place. The <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>
         * values are only used in symmetric encryption keys with imported key material. The other values,
         * <code>CURRENT</code> and <code>NON_CURRENT</code>, are used for all KMS keys that support automatic or
         * on-demand key rotation.
         * </p>
         * 
         * @param keyMaterialState
         *        There are four possible values for this field: <code>CURRENT</code>, <code>NON_CURRENT</code>,
         *        <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>. KMS uses
         *        <code>CURRENT</code> key material for both encryption and decryption and <code>NON_CURRENT</code> key
         *        material only for decryption. <code>PENDING_ROTATION</code> identifies key material that has been
         *        imported for on-demand key rotation but the rotation hasn't completed. The key material state
         *        <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> is unique to multi-region, symmetric encryption
         *        keys with imported key material. It indicates key material that has been imported into the primary
         *        Region key but not all of the replica Region keys. When this key material is imported in to all of the
         *        replica Region keys, the key material state will change to <code>PENDING_ROTATION</code>. Key material
         *        in <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> or <code>PENDING_ROTATION</code> state is not
         *        permanently associated with the KMS key. You can delete this key material and import different key
         *        material in its place. The <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and
         *        <code>PENDING_ROTATION</code> values are only used in symmetric encryption keys with imported key
         *        material. The other values, <code>CURRENT</code> and <code>NON_CURRENT</code>, are used for all KMS
         *        keys that support automatic or on-demand key rotation.
         * @see KeyMaterialState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyMaterialState
         */
        Builder keyMaterialState(String keyMaterialState);

        /**
         * <p>
         * There are four possible values for this field: <code>CURRENT</code>, <code>NON_CURRENT</code>,
         * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>. KMS uses
         * <code>CURRENT</code> key material for both encryption and decryption and <code>NON_CURRENT</code> key
         * material only for decryption. <code>PENDING_ROTATION</code> identifies key material that has been imported
         * for on-demand key rotation but the rotation hasn't completed. The key material state
         * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> is unique to multi-region, symmetric encryption keys
         * with imported key material. It indicates key material that has been imported into the primary Region key but
         * not all of the replica Region keys. When this key material is imported in to all of the replica Region keys,
         * the key material state will change to <code>PENDING_ROTATION</code>. Key material in
         * <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> or <code>PENDING_ROTATION</code> state is not
         * permanently associated with the KMS key. You can delete this key material and import different key material
         * in its place. The <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>
         * values are only used in symmetric encryption keys with imported key material. The other values,
         * <code>CURRENT</code> and <code>NON_CURRENT</code>, are used for all KMS keys that support automatic or
         * on-demand key rotation.
         * </p>
         * 
         * @param keyMaterialState
         *        There are four possible values for this field: <code>CURRENT</code>, <code>NON_CURRENT</code>,
         *        <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and <code>PENDING_ROTATION</code>. KMS uses
         *        <code>CURRENT</code> key material for both encryption and decryption and <code>NON_CURRENT</code> key
         *        material only for decryption. <code>PENDING_ROTATION</code> identifies key material that has been
         *        imported for on-demand key rotation but the rotation hasn't completed. The key material state
         *        <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> is unique to multi-region, symmetric encryption
         *        keys with imported key material. It indicates key material that has been imported into the primary
         *        Region key but not all of the replica Region keys. When this key material is imported in to all of the
         *        replica Region keys, the key material state will change to <code>PENDING_ROTATION</code>. Key material
         *        in <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> or <code>PENDING_ROTATION</code> state is not
         *        permanently associated with the KMS key. You can delete this key material and import different key
         *        material in its place. The <code>PENDING_MULTI_REGION_IMPORT_AND_ROTATION</code> and
         *        <code>PENDING_ROTATION</code> values are only used in symmetric encryption keys with imported key
         *        material. The other values, <code>CURRENT</code> and <code>NON_CURRENT</code>, are used for all KMS
         *        keys that support automatic or on-demand key rotation.
         * @see KeyMaterialState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyMaterialState
         */
        Builder keyMaterialState(KeyMaterialState keyMaterialState);

        /**
         * <p>
         * Indicates if the key material is configured to automatically expire. There are two possible values for this
         * field: <code>KEY_MATERIAL_EXPIRES</code> and <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. For any key material
         * that expires, the expiration date and time is indicated in <code>ValidTo</code>. This field is only present
         * for symmetric encryption KMS keys with <code>EXTERNAL</code> origin.
         * </p>
         * 
         * @param expirationModel
         *        Indicates if the key material is configured to automatically expire. There are two possible values for
         *        this field: <code>KEY_MATERIAL_EXPIRES</code> and <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. For any
         *        key material that expires, the expiration date and time is indicated in <code>ValidTo</code>. This
         *        field is only present for symmetric encryption KMS keys with <code>EXTERNAL</code> origin.
         * @see ExpirationModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationModelType
         */
        Builder expirationModel(String expirationModel);

        /**
         * <p>
         * Indicates if the key material is configured to automatically expire. There are two possible values for this
         * field: <code>KEY_MATERIAL_EXPIRES</code> and <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. For any key material
         * that expires, the expiration date and time is indicated in <code>ValidTo</code>. This field is only present
         * for symmetric encryption KMS keys with <code>EXTERNAL</code> origin.
         * </p>
         * 
         * @param expirationModel
         *        Indicates if the key material is configured to automatically expire. There are two possible values for
         *        this field: <code>KEY_MATERIAL_EXPIRES</code> and <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. For any
         *        key material that expires, the expiration date and time is indicated in <code>ValidTo</code>. This
         *        field is only present for symmetric encryption KMS keys with <code>EXTERNAL</code> origin.
         * @see ExpirationModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationModelType
         */
        Builder expirationModel(ExpirationModelType expirationModel);

        /**
         * <p>
         * Date and time at which the key material expires. This field is only present for symmetric encryption KMS keys
         * with <code>EXTERNAL</code> origin in rotation list entries with an <code>ExpirationModel</code> value of
         * <code>KEY_MATERIAL_EXPIRES</code>.
         * </p>
         * 
         * @param validTo
         *        Date and time at which the key material expires. This field is only present for symmetric encryption
         *        KMS keys with <code>EXTERNAL</code> origin in rotation list entries with an
         *        <code>ExpirationModel</code> value of <code>KEY_MATERIAL_EXPIRES</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validTo(Instant validTo);

        /**
         * <p>
         * Date and time that the key material rotation completed. Formatted as Unix time. This field is not present for
         * the first key material or an imported key material in <code>PENDING_ROTATION</code> state.
         * </p>
         * 
         * @param rotationDate
         *        Date and time that the key material rotation completed. Formatted as Unix time. This field is not
         *        present for the first key material or an imported key material in <code>PENDING_ROTATION</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationDate(Instant rotationDate);

        /**
         * <p>
         * Identifies whether the key material rotation was a scheduled <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html">automatic
         * rotation</a> or an <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html">on-demand
         * rotation</a>. This field is not present for the first key material or an imported key material in
         * <code>PENDING_ROTATION</code> state.
         * </p>
         * 
         * @param rotationType
         *        Identifies whether the key material rotation was a scheduled <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html"
         *        >automatic rotation</a> or an <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html">on-demand
         *        rotation</a>. This field is not present for the first key material or an imported key material in
         *        <code>PENDING_ROTATION</code> state.
         * @see RotationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RotationType
         */
        Builder rotationType(String rotationType);

        /**
         * <p>
         * Identifies whether the key material rotation was a scheduled <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html">automatic
         * rotation</a> or an <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html">on-demand
         * rotation</a>. This field is not present for the first key material or an imported key material in
         * <code>PENDING_ROTATION</code> state.
         * </p>
         * 
         * @param rotationType
         *        Identifies whether the key material rotation was a scheduled <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html"
         *        >automatic rotation</a> or an <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html">on-demand
         *        rotation</a>. This field is not present for the first key material or an imported key material in
         *        <code>PENDING_ROTATION</code> state.
         * @see RotationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RotationType
         */
        Builder rotationType(RotationType rotationType);
    }

    static final class BuilderImpl implements Builder {
        private String keyId;

        private String keyMaterialId;

        private String keyMaterialDescription;

        private String importState;

        private String keyMaterialState;

        private String expirationModel;

        private Instant validTo;

        private Instant rotationDate;

        private String rotationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationsListEntry model) {
            keyId(model.keyId);
            keyMaterialId(model.keyMaterialId);
            keyMaterialDescription(model.keyMaterialDescription);
            importState(model.importState);
            keyMaterialState(model.keyMaterialState);
            expirationModel(model.expirationModel);
            validTo(model.validTo);
            rotationDate(model.rotationDate);
            rotationType(model.rotationType);
        }

        public final String getKeyId() {
            return keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getKeyMaterialId() {
            return keyMaterialId;
        }

        public final void setKeyMaterialId(String keyMaterialId) {
            this.keyMaterialId = keyMaterialId;
        }

        @Override
        public final Builder keyMaterialId(String keyMaterialId) {
            this.keyMaterialId = keyMaterialId;
            return this;
        }

        public final String getKeyMaterialDescription() {
            return keyMaterialDescription;
        }

        public final void setKeyMaterialDescription(String keyMaterialDescription) {
            this.keyMaterialDescription = keyMaterialDescription;
        }

        @Override
        public final Builder keyMaterialDescription(String keyMaterialDescription) {
            this.keyMaterialDescription = keyMaterialDescription;
            return this;
        }

        public final String getImportState() {
            return importState;
        }

        public final void setImportState(String importState) {
            this.importState = importState;
        }

        @Override
        public final Builder importState(String importState) {
            this.importState = importState;
            return this;
        }

        @Override
        public final Builder importState(ImportState importState) {
            this.importState(importState == null ? null : importState.toString());
            return this;
        }

        public final String getKeyMaterialState() {
            return keyMaterialState;
        }

        public final void setKeyMaterialState(String keyMaterialState) {
            this.keyMaterialState = keyMaterialState;
        }

        @Override
        public final Builder keyMaterialState(String keyMaterialState) {
            this.keyMaterialState = keyMaterialState;
            return this;
        }

        @Override
        public final Builder keyMaterialState(KeyMaterialState keyMaterialState) {
            this.keyMaterialState(keyMaterialState == null ? null : keyMaterialState.toString());
            return this;
        }

        public final String getExpirationModel() {
            return expirationModel;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel == null ? null : expirationModel.toString());
            return this;
        }

        public final Instant getValidTo() {
            return validTo;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final Instant getRotationDate() {
            return rotationDate;
        }

        public final void setRotationDate(Instant rotationDate) {
            this.rotationDate = rotationDate;
        }

        @Override
        public final Builder rotationDate(Instant rotationDate) {
            this.rotationDate = rotationDate;
            return this;
        }

        public final String getRotationType() {
            return rotationType;
        }

        public final void setRotationType(String rotationType) {
            this.rotationType = rotationType;
        }

        @Override
        public final Builder rotationType(String rotationType) {
            this.rotationType = rotationType;
            return this;
        }

        @Override
        public final Builder rotationType(RotationType rotationType) {
            this.rotationType(rotationType == null ? null : rotationType.toString());
            return this;
        }

        @Override
        public RotationsListEntry build() {
            return new RotationsListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
