/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.XksProxyAuthenticationCredentialType;
import software.amazon.awssdk.services.kms.model.XksProxyConnectivityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomKeyStoreRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, UpdateCustomKeyStoreRequest> {
    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomKeyStoreId").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::customKeyStoreId)).setter(UpdateCustomKeyStoreRequest.setter(Builder::customKeyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()}).build();
    private static final SdkField<String> NEW_CUSTOM_KEY_STORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewCustomKeyStoreName").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::newCustomKeyStoreName)).setter(UpdateCustomKeyStoreRequest.setter(Builder::newCustomKeyStoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewCustomKeyStoreName").build()}).build();
    private static final SdkField<String> KEY_STORE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyStorePassword").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::keyStorePassword)).setter(UpdateCustomKeyStoreRequest.setter(Builder::keyStorePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStorePassword").build()}).build();
    private static final SdkField<String> CLOUD_HSM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudHsmClusterId").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::cloudHsmClusterId)).setter(UpdateCustomKeyStoreRequest.setter(Builder::cloudHsmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudHsmClusterId").build()}).build();
    private static final SdkField<String> XKS_PROXY_URI_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XksProxyUriEndpoint").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::xksProxyUriEndpoint)).setter(UpdateCustomKeyStoreRequest.setter(Builder::xksProxyUriEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyUriEndpoint").build()}).build();
    private static final SdkField<String> XKS_PROXY_URI_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XksProxyUriPath").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::xksProxyUriPath)).setter(UpdateCustomKeyStoreRequest.setter(Builder::xksProxyUriPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyUriPath").build()}).build();
    private static final SdkField<String> XKS_PROXY_VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XksProxyVpcEndpointServiceName").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::xksProxyVpcEndpointServiceName)).setter(UpdateCustomKeyStoreRequest.setter(Builder::xksProxyVpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyVpcEndpointServiceName").build()}).build();
    private static final SdkField<XksProxyAuthenticationCredentialType> XKS_PROXY_AUTHENTICATION_CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XksProxyAuthenticationCredential").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::xksProxyAuthenticationCredential)).setter(UpdateCustomKeyStoreRequest.setter(Builder::xksProxyAuthenticationCredential)).constructor(XksProxyAuthenticationCredentialType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyAuthenticationCredential").build()}).build();
    private static final SdkField<String> XKS_PROXY_CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XksProxyConnectivity").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::xksProxyConnectivityAsString)).setter(UpdateCustomKeyStoreRequest.setter(Builder::xksProxyConnectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyConnectivity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_KEY_STORE_ID_FIELD, NEW_CUSTOM_KEY_STORE_NAME_FIELD, KEY_STORE_PASSWORD_FIELD, CLOUD_HSM_CLUSTER_ID_FIELD, XKS_PROXY_URI_ENDPOINT_FIELD, XKS_PROXY_URI_PATH_FIELD, XKS_PROXY_VPC_ENDPOINT_SERVICE_NAME_FIELD, XKS_PROXY_AUTHENTICATION_CREDENTIAL_FIELD, XKS_PROXY_CONNECTIVITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCustomKeyStoreRequest.memberNameToFieldInitializer();
    private final String customKeyStoreId;
    private final String newCustomKeyStoreName;
    private final String keyStorePassword;
    private final String cloudHsmClusterId;
    private final String xksProxyUriEndpoint;
    private final String xksProxyUriPath;
    private final String xksProxyVpcEndpointServiceName;
    private final XksProxyAuthenticationCredentialType xksProxyAuthenticationCredential;
    private final String xksProxyConnectivity;

    private UpdateCustomKeyStoreRequest(BuilderImpl builder) {
        super(builder);
        this.customKeyStoreId = builder.customKeyStoreId;
        this.newCustomKeyStoreName = builder.newCustomKeyStoreName;
        this.keyStorePassword = builder.keyStorePassword;
        this.cloudHsmClusterId = builder.cloudHsmClusterId;
        this.xksProxyUriEndpoint = builder.xksProxyUriEndpoint;
        this.xksProxyUriPath = builder.xksProxyUriPath;
        this.xksProxyVpcEndpointServiceName = builder.xksProxyVpcEndpointServiceName;
        this.xksProxyAuthenticationCredential = builder.xksProxyAuthenticationCredential;
        this.xksProxyConnectivity = builder.xksProxyConnectivity;
    }

    public final String customKeyStoreId() {
        return this.customKeyStoreId;
    }

    public final String newCustomKeyStoreName() {
        return this.newCustomKeyStoreName;
    }

    public final String keyStorePassword() {
        return this.keyStorePassword;
    }

    public final String cloudHsmClusterId() {
        return this.cloudHsmClusterId;
    }

    public final String xksProxyUriEndpoint() {
        return this.xksProxyUriEndpoint;
    }

    public final String xksProxyUriPath() {
        return this.xksProxyUriPath;
    }

    public final String xksProxyVpcEndpointServiceName() {
        return this.xksProxyVpcEndpointServiceName;
    }

    public final XksProxyAuthenticationCredentialType xksProxyAuthenticationCredential() {
        return this.xksProxyAuthenticationCredential;
    }

    public final XksProxyConnectivityType xksProxyConnectivity() {
        return XksProxyConnectivityType.fromValue(this.xksProxyConnectivity);
    }

    public final String xksProxyConnectivityAsString() {
        return this.xksProxyConnectivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newCustomKeyStoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStorePassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudHsmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyUriEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyUriPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyVpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyAuthenticationCredential());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyConnectivityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomKeyStoreRequest)) {
            return false;
        }
        UpdateCustomKeyStoreRequest other = (UpdateCustomKeyStoreRequest)((Object)obj);
        return Objects.equals(this.customKeyStoreId(), other.customKeyStoreId()) && Objects.equals(this.newCustomKeyStoreName(), other.newCustomKeyStoreName()) && Objects.equals(this.keyStorePassword(), other.keyStorePassword()) && Objects.equals(this.cloudHsmClusterId(), other.cloudHsmClusterId()) && Objects.equals(this.xksProxyUriEndpoint(), other.xksProxyUriEndpoint()) && Objects.equals(this.xksProxyUriPath(), other.xksProxyUriPath()) && Objects.equals(this.xksProxyVpcEndpointServiceName(), other.xksProxyVpcEndpointServiceName()) && Objects.equals(this.xksProxyAuthenticationCredential(), other.xksProxyAuthenticationCredential()) && Objects.equals(this.xksProxyConnectivityAsString(), other.xksProxyConnectivityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCustomKeyStoreRequest").add("CustomKeyStoreId", (Object)this.customKeyStoreId()).add("NewCustomKeyStoreName", (Object)this.newCustomKeyStoreName()).add("KeyStorePassword", (Object)(this.keyStorePassword() == null ? null : "*** Sensitive Data Redacted ***")).add("CloudHsmClusterId", (Object)this.cloudHsmClusterId()).add("XksProxyUriEndpoint", (Object)this.xksProxyUriEndpoint()).add("XksProxyUriPath", (Object)this.xksProxyUriPath()).add("XksProxyVpcEndpointServiceName", (Object)this.xksProxyVpcEndpointServiceName()).add("XksProxyAuthenticationCredential", (Object)this.xksProxyAuthenticationCredential()).add("XksProxyConnectivity", (Object)this.xksProxyConnectivityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomKeyStoreId": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreId()));
            }
            case "NewCustomKeyStoreName": {
                return Optional.ofNullable(clazz.cast(this.newCustomKeyStoreName()));
            }
            case "KeyStorePassword": {
                return Optional.ofNullable(clazz.cast(this.keyStorePassword()));
            }
            case "CloudHsmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudHsmClusterId()));
            }
            case "XksProxyUriEndpoint": {
                return Optional.ofNullable(clazz.cast(this.xksProxyUriEndpoint()));
            }
            case "XksProxyUriPath": {
                return Optional.ofNullable(clazz.cast(this.xksProxyUriPath()));
            }
            case "XksProxyVpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.xksProxyVpcEndpointServiceName()));
            }
            case "XksProxyAuthenticationCredential": {
                return Optional.ofNullable(clazz.cast(this.xksProxyAuthenticationCredential()));
            }
            case "XksProxyConnectivity": {
                return Optional.ofNullable(clazz.cast(this.xksProxyConnectivityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomKeyStoreId", CUSTOM_KEY_STORE_ID_FIELD);
        map.put("NewCustomKeyStoreName", NEW_CUSTOM_KEY_STORE_NAME_FIELD);
        map.put("KeyStorePassword", KEY_STORE_PASSWORD_FIELD);
        map.put("CloudHsmClusterId", CLOUD_HSM_CLUSTER_ID_FIELD);
        map.put("XksProxyUriEndpoint", XKS_PROXY_URI_ENDPOINT_FIELD);
        map.put("XksProxyUriPath", XKS_PROXY_URI_PATH_FIELD);
        map.put("XksProxyVpcEndpointServiceName", XKS_PROXY_VPC_ENDPOINT_SERVICE_NAME_FIELD);
        map.put("XksProxyAuthenticationCredential", XKS_PROXY_AUTHENTICATION_CREDENTIAL_FIELD);
        map.put("XksProxyConnectivity", XKS_PROXY_CONNECTIVITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomKeyStoreRequest, T> g) {
        return obj -> g.apply((UpdateCustomKeyStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String customKeyStoreId;
        private String newCustomKeyStoreName;
        private String keyStorePassword;
        private String cloudHsmClusterId;
        private String xksProxyUriEndpoint;
        private String xksProxyUriPath;
        private String xksProxyVpcEndpointServiceName;
        private XksProxyAuthenticationCredentialType xksProxyAuthenticationCredential;
        private String xksProxyConnectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomKeyStoreRequest model) {
            super(model);
            this.customKeyStoreId(model.customKeyStoreId);
            this.newCustomKeyStoreName(model.newCustomKeyStoreName);
            this.keyStorePassword(model.keyStorePassword);
            this.cloudHsmClusterId(model.cloudHsmClusterId);
            this.xksProxyUriEndpoint(model.xksProxyUriEndpoint);
            this.xksProxyUriPath(model.xksProxyUriPath);
            this.xksProxyVpcEndpointServiceName(model.xksProxyVpcEndpointServiceName);
            this.xksProxyAuthenticationCredential(model.xksProxyAuthenticationCredential);
            this.xksProxyConnectivity(model.xksProxyConnectivity);
        }

        public final String getCustomKeyStoreId() {
            return this.customKeyStoreId;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        @Override
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        public final String getNewCustomKeyStoreName() {
            return this.newCustomKeyStoreName;
        }

        public final void setNewCustomKeyStoreName(String newCustomKeyStoreName) {
            this.newCustomKeyStoreName = newCustomKeyStoreName;
        }

        @Override
        public final Builder newCustomKeyStoreName(String newCustomKeyStoreName) {
            this.newCustomKeyStoreName = newCustomKeyStoreName;
            return this;
        }

        public final String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public final void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Override
        public final Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public final String getCloudHsmClusterId() {
            return this.cloudHsmClusterId;
        }

        public final void setCloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
        }

        @Override
        public final Builder cloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
            return this;
        }

        public final String getXksProxyUriEndpoint() {
            return this.xksProxyUriEndpoint;
        }

        public final void setXksProxyUriEndpoint(String xksProxyUriEndpoint) {
            this.xksProxyUriEndpoint = xksProxyUriEndpoint;
        }

        @Override
        public final Builder xksProxyUriEndpoint(String xksProxyUriEndpoint) {
            this.xksProxyUriEndpoint = xksProxyUriEndpoint;
            return this;
        }

        public final String getXksProxyUriPath() {
            return this.xksProxyUriPath;
        }

        public final void setXksProxyUriPath(String xksProxyUriPath) {
            this.xksProxyUriPath = xksProxyUriPath;
        }

        @Override
        public final Builder xksProxyUriPath(String xksProxyUriPath) {
            this.xksProxyUriPath = xksProxyUriPath;
            return this;
        }

        public final String getXksProxyVpcEndpointServiceName() {
            return this.xksProxyVpcEndpointServiceName;
        }

        public final void setXksProxyVpcEndpointServiceName(String xksProxyVpcEndpointServiceName) {
            this.xksProxyVpcEndpointServiceName = xksProxyVpcEndpointServiceName;
        }

        @Override
        public final Builder xksProxyVpcEndpointServiceName(String xksProxyVpcEndpointServiceName) {
            this.xksProxyVpcEndpointServiceName = xksProxyVpcEndpointServiceName;
            return this;
        }

        public final XksProxyAuthenticationCredentialType.Builder getXksProxyAuthenticationCredential() {
            return this.xksProxyAuthenticationCredential != null ? this.xksProxyAuthenticationCredential.toBuilder() : null;
        }

        public final void setXksProxyAuthenticationCredential(XksProxyAuthenticationCredentialType.BuilderImpl xksProxyAuthenticationCredential) {
            this.xksProxyAuthenticationCredential = xksProxyAuthenticationCredential != null ? xksProxyAuthenticationCredential.build() : null;
        }

        @Override
        public final Builder xksProxyAuthenticationCredential(XksProxyAuthenticationCredentialType xksProxyAuthenticationCredential) {
            this.xksProxyAuthenticationCredential = xksProxyAuthenticationCredential;
            return this;
        }

        public final String getXksProxyConnectivity() {
            return this.xksProxyConnectivity;
        }

        public final void setXksProxyConnectivity(String xksProxyConnectivity) {
            this.xksProxyConnectivity = xksProxyConnectivity;
        }

        @Override
        public final Builder xksProxyConnectivity(String xksProxyConnectivity) {
            this.xksProxyConnectivity = xksProxyConnectivity;
            return this;
        }

        @Override
        public final Builder xksProxyConnectivity(XksProxyConnectivityType xksProxyConnectivity) {
            this.xksProxyConnectivity(xksProxyConnectivity == null ? null : xksProxyConnectivity.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomKeyStoreRequest build() {
            return new UpdateCustomKeyStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCustomKeyStoreRequest> {
        public Builder customKeyStoreId(String var1);

        public Builder newCustomKeyStoreName(String var1);

        public Builder keyStorePassword(String var1);

        public Builder cloudHsmClusterId(String var1);

        public Builder xksProxyUriEndpoint(String var1);

        public Builder xksProxyUriPath(String var1);

        public Builder xksProxyVpcEndpointServiceName(String var1);

        public Builder xksProxyAuthenticationCredential(XksProxyAuthenticationCredentialType var1);

        default public Builder xksProxyAuthenticationCredential(Consumer<XksProxyAuthenticationCredentialType.Builder> xksProxyAuthenticationCredential) {
            return this.xksProxyAuthenticationCredential((XksProxyAuthenticationCredentialType)((XksProxyAuthenticationCredentialType.Builder)XksProxyAuthenticationCredentialType.builder().applyMutation(xksProxyAuthenticationCredential)).build());
        }

        public Builder xksProxyConnectivity(String var1);

        public Builder xksProxyConnectivity(XksProxyConnectivityType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

