/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.RotationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RotationsListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RotationsListEntry> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(RotationsListEntry.getter(RotationsListEntry::keyId)).setter(RotationsListEntry.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Instant> ROTATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RotationDate").getter(RotationsListEntry.getter(RotationsListEntry::rotationDate)).setter(RotationsListEntry.setter(Builder::rotationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationDate").build()}).build();
    private static final SdkField<String> ROTATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationType").getter(RotationsListEntry.getter(RotationsListEntry::rotationTypeAsString)).setter(RotationsListEntry.setter(Builder::rotationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, ROTATION_DATE_FIELD, ROTATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyId;
    private final Instant rotationDate;
    private final String rotationType;

    private RotationsListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.rotationDate = builder.rotationDate;
        this.rotationType = builder.rotationType;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final Instant rotationDate() {
        return this.rotationDate;
    }

    public final RotationType rotationType() {
        return RotationType.fromValue(this.rotationType);
    }

    public final String rotationTypeAsString() {
        return this.rotationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationsListEntry)) {
            return false;
        }
        RotationsListEntry other = (RotationsListEntry)obj;
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.rotationDate(), other.rotationDate()) && Objects.equals(this.rotationTypeAsString(), other.rotationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RotationsListEntry").add("KeyId", (Object)this.keyId()).add("RotationDate", (Object)this.rotationDate()).add("RotationType", (Object)this.rotationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "RotationDate": {
                return Optional.ofNullable(clazz.cast(this.rotationDate()));
            }
            case "RotationType": {
                return Optional.ofNullable(clazz.cast(this.rotationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RotationsListEntry, T> g) {
        return obj -> g.apply((RotationsListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private Instant rotationDate;
        private String rotationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationsListEntry model) {
            this.keyId(model.keyId);
            this.rotationDate(model.rotationDate);
            this.rotationType(model.rotationType);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final Instant getRotationDate() {
            return this.rotationDate;
        }

        public final void setRotationDate(Instant rotationDate) {
            this.rotationDate = rotationDate;
        }

        @Override
        public final Builder rotationDate(Instant rotationDate) {
            this.rotationDate = rotationDate;
            return this;
        }

        public final String getRotationType() {
            return this.rotationType;
        }

        public final void setRotationType(String rotationType) {
            this.rotationType = rotationType;
        }

        @Override
        public final Builder rotationType(String rotationType) {
            this.rotationType = rotationType;
            return this;
        }

        @Override
        public final Builder rotationType(RotationType rotationType) {
            this.rotationType(rotationType == null ? null : rotationType.toString());
            return this;
        }

        public RotationsListEntry build() {
            return new RotationsListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RotationsListEntry> {
        public Builder keyId(String var1);

        public Builder rotationDate(Instant var1);

        public Builder rotationType(String var1);

        public Builder rotationType(RotationType var1);
    }
}

