/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleKeyDeletionResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, ScheduleKeyDeletionResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduleKeyDeletionResponse.getter(ScheduleKeyDeletionResponse::keyId)).setter(ScheduleKeyDeletionResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Instant> DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ScheduleKeyDeletionResponse.getter(ScheduleKeyDeletionResponse::deletionDate)).setter(ScheduleKeyDeletionResponse.setter(Builder::deletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, DELETION_DATE_FIELD));
    private final String keyId;
    private final Instant deletionDate;

    private ScheduleKeyDeletionResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.deletionDate = builder.deletionDate;
    }

    public String keyId() {
        return this.keyId;
    }

    public Instant deletionDate() {
        return this.deletionDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleKeyDeletionResponse)) {
            return false;
        }
        ScheduleKeyDeletionResponse other = (ScheduleKeyDeletionResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.deletionDate(), other.deletionDate());
    }

    public String toString() {
        return ToString.builder((String)"ScheduleKeyDeletionResponse").add("KeyId", (Object)this.keyId()).add("DeletionDate", (Object)this.deletionDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "DeletionDate": {
                return Optional.ofNullable(clazz.cast(this.deletionDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleKeyDeletionResponse, T> g) {
        return obj -> g.apply((ScheduleKeyDeletionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private Instant deletionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleKeyDeletionResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.deletionDate(model.deletionDate);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        @Override
        public ScheduleKeyDeletionResponse build() {
            return new ScheduleKeyDeletionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ScheduleKeyDeletionResponse> {
        public Builder keyId(String var1);

        public Builder deletionDate(Instant var1);
    }
}

