/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;

public class ListKeysIterable
implements SdkIterable<ListKeysResponse> {
    private final KMSClient client;
    private final ListKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeysIterable(KMSClient client, ListKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListKeysResponseFetcher();
    }

    public Iterator<ListKeysResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<KeyListEntry> keys() {
        Function<ListKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.keys() != null) {
                return response.keys().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListKeysIterable resume(ListKeysResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListKeysIterable(this.client, (ListKeysRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListKeysIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListKeysResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListKeysResponseFetcher
    implements SyncPageFetcher<ListKeysResponse> {
        private ListKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListKeysResponse previousPage) {
            return previousPage.truncated();
        }

        public ListKeysResponse nextPage(ListKeysResponse previousPage) {
            if (previousPage == null) {
                return ListKeysIterable.this.client.listKeys(ListKeysIterable.this.firstRequest);
            }
            return ListKeysIterable.this.client.listKeys((ListKeysRequest)((Object)ListKeysIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

