/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.TagMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Tag
implements StructuredPojo,
ToCopyableBuilder<Builder, Tag> {
    private final String tagKey;
    private final String tagValue;

    private Tag(BuilderImpl builder) {
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
    }

    public String tagKey() {
        return this.tagKey;
    }

    public String tagValue() {
        return this.tagValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equals(this.tagKey(), other.tagKey()) && Objects.equals(this.tagValue(), other.tagValue());
    }

    public String toString() {
        return ToString.builder((String)"Tag").add("TagKey", (Object)this.tagKey()).add("TagValue", (Object)this.tagValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagKey": {
                return Optional.of(clazz.cast(this.tagKey()));
            }
            case "TagValue": {
                return Optional.of(clazz.cast(this.tagValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String tagKey;
        private String tagValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            this.tagKey(model.tagKey);
            this.tagValue(model.tagValue);
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        public Tag build() {
            return new Tag(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Tag> {
        public Builder tagKey(String var1);

        public Builder tagValue(String var1);
    }
}

