/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.KMSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateRandomResponse
extends KMSResponse
implements ToCopyableBuilder<Builder, GenerateRandomResponse> {
    private final ByteBuffer plaintext;

    private GenerateRandomResponse(BuilderImpl builder) {
        super(builder);
        this.plaintext = builder.plaintext;
    }

    public ByteBuffer plaintext() {
        return this.plaintext == null ? null : this.plaintext.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.plaintext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRandomResponse)) {
            return false;
        }
        GenerateRandomResponse other = (GenerateRandomResponse)((Object)obj);
        return Objects.equals(this.plaintext(), other.plaintext());
    }

    public String toString() {
        return ToString.builder((String)"GenerateRandomResponse").add("Plaintext", (Object)this.plaintext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Plaintext": {
                return Optional.of(clazz.cast(this.plaintext()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KMSResponse.BuilderImpl
    implements Builder {
        private ByteBuffer plaintext;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRandomResponse model) {
            this.plaintext(model.plaintext);
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext;
        }

        @Override
        public final Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy((ByteBuffer)plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy((ByteBuffer)plaintext);
        }

        @Override
        public GenerateRandomResponse build() {
            return new GenerateRandomResponse(this);
        }
    }

    public static interface Builder
    extends KMSResponse.Builder,
    CopyableBuilder<Builder, GenerateRandomResponse> {
        public Builder plaintext(ByteBuffer var1);
    }
}

