/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.AlreadyExistsException;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.CreateAliasRequest;
import software.amazon.awssdk.services.kms.model.CreateAliasResponse;
import software.amazon.awssdk.services.kms.model.CreateGrantRequest;
import software.amazon.awssdk.services.kms.model.CreateGrantResponse;
import software.amazon.awssdk.services.kms.model.CreateKeyRequest;
import software.amazon.awssdk.services.kms.model.CreateKeyResponse;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DeleteAliasRequest;
import software.amazon.awssdk.services.kms.model.DeleteAliasResponse;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.DependencyTimeoutException;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.DisabledException;
import software.amazon.awssdk.services.kms.model.EnableKeyRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyResponse;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.ExpiredImportTokenException;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse;
import software.amazon.awssdk.services.kms.model.GenerateRandomRequest;
import software.amazon.awssdk.services.kms.model.GenerateRandomResponse;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse;
import software.amazon.awssdk.services.kms.model.GetParametersForImportRequest;
import software.amazon.awssdk.services.kms.model.GetParametersForImportResponse;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.IncorrectKeyMaterialException;
import software.amazon.awssdk.services.kms.model.InvalidAliasNameException;
import software.amazon.awssdk.services.kms.model.InvalidArnException;
import software.amazon.awssdk.services.kms.model.InvalidCiphertextException;
import software.amazon.awssdk.services.kms.model.InvalidGrantIdException;
import software.amazon.awssdk.services.kms.model.InvalidGrantTokenException;
import software.amazon.awssdk.services.kms.model.InvalidImportTokenException;
import software.amazon.awssdk.services.kms.model.InvalidKeyUsageException;
import software.amazon.awssdk.services.kms.model.InvalidMarkerException;
import software.amazon.awssdk.services.kms.model.KMSException;
import software.amazon.awssdk.services.kms.model.KMSInternalException;
import software.amazon.awssdk.services.kms.model.KMSInvalidStateException;
import software.amazon.awssdk.services.kms.model.KeyUnavailableException;
import software.amazon.awssdk.services.kms.model.LimitExceededException;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;
import software.amazon.awssdk.services.kms.model.ListResourceTagsRequest;
import software.amazon.awssdk.services.kms.model.ListResourceTagsResponse;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse;
import software.amazon.awssdk.services.kms.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.kms.model.NotFoundException;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.ReEncryptRequest;
import software.amazon.awssdk.services.kms.model.ReEncryptResponse;
import software.amazon.awssdk.services.kms.model.RetireGrantRequest;
import software.amazon.awssdk.services.kms.model.RetireGrantResponse;
import software.amazon.awssdk.services.kms.model.RevokeGrantRequest;
import software.amazon.awssdk.services.kms.model.RevokeGrantResponse;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.TagException;
import software.amazon.awssdk.services.kms.model.TagResourceRequest;
import software.amazon.awssdk.services.kms.model.TagResourceResponse;
import software.amazon.awssdk.services.kms.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kms.model.UntagResourceRequest;
import software.amazon.awssdk.services.kms.model.UntagResourceResponse;
import software.amazon.awssdk.services.kms.model.UpdateAliasRequest;
import software.amazon.awssdk.services.kms.model.UpdateAliasResponse;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionResponse;
import software.amazon.awssdk.services.kms.paginators.ListAliasesPaginator;
import software.amazon.awssdk.services.kms.paginators.ListGrantsPaginator;
import software.amazon.awssdk.services.kms.paginators.ListKeyPoliciesPaginator;
import software.amazon.awssdk.services.kms.paginators.ListKeysPaginator;
import software.amazon.awssdk.services.kms.transform.CancelKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CancelKeyDeletionResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateAliasResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.CreateGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateGrantResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.CreateKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DecryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DecryptResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteAliasResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteImportedKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteImportedKeyMaterialResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRotationResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRotationResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.EncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EncryptResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyWithoutPlaintextRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyWithoutPlaintextResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateRandomRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateRandomResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyRotationStatusRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyRotationStatusResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GetParametersForImportRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetParametersForImportResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ImportKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ImportKeyMaterialResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListAliasesResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListGrantsResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyPoliciesResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeysRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeysResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListResourceTagsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListResourceTagsResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListRetirableGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListRetirableGrantsResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.PutKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.PutKeyPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ReEncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ReEncryptResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.RetireGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RetireGrantResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.RevokeGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RevokeGrantResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ScheduleKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ScheduleKeyDeletionResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateAliasResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateKeyDescriptionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateKeyDescriptionResponseUnmarshaller;

@SdkInternalApi
final class DefaultKMSClient
implements KMSClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultKMSClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "kms";
    }

    @Override
    public CancelKeyDeletionResponse cancelKeyDeletion(CancelKeyDeletionRequest cancelKeyDeletionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelKeyDeletionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CancelKeyDeletionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelKeyDeletionRequest).withMarshaller((Marshaller)new CancelKeyDeletionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws DependencyTimeoutException, AlreadyExistsException, NotFoundException, InvalidAliasNameException, KMSInternalException, LimitExceededException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAliasResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAliasRequest).withMarshaller((Marshaller)new CreateAliasRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateGrantResponse createGrant(CreateGrantRequest createGrantRequest) throws NotFoundException, DisabledException, DependencyTimeoutException, InvalidArnException, KMSInternalException, InvalidGrantTokenException, LimitExceededException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGrantResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGrantRequest).withMarshaller((Marshaller)new CreateGrantRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateKeyResponse createKey(CreateKeyRequest createKeyRequest) throws MalformedPolicyDocumentException, DependencyTimeoutException, InvalidArnException, UnsupportedOperationException, KMSInternalException, LimitExceededException, TagException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateKeyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createKeyRequest).withMarshaller((Marshaller)new CreateKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DecryptResponse decrypt(DecryptRequest decryptRequest) throws NotFoundException, DisabledException, InvalidCiphertextException, KeyUnavailableException, DependencyTimeoutException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DecryptResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DecryptResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)decryptRequest).withMarshaller((Marshaller)new DecryptRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAliasResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAliasRequest).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteImportedKeyMaterialResponse deleteImportedKeyMaterial(DeleteImportedKeyMaterialRequest deleteImportedKeyMaterialRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteImportedKeyMaterialResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteImportedKeyMaterialResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteImportedKeyMaterialRequest).withMarshaller((Marshaller)new DeleteImportedKeyMaterialRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeKeyResponse describeKey(DescribeKeyRequest describeKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeKeyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeKeyRequest).withMarshaller((Marshaller)new DescribeKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableKeyResponse disableKey(DisableKeyRequest disableKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableKeyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisableKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableKeyRequest).withMarshaller((Marshaller)new DisableKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableKeyRotationResponse disableKeyRotation(DisableKeyRotationRequest disableKeyRotationRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, UnsupportedOperationException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableKeyRotationResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisableKeyRotationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableKeyRotationRequest).withMarshaller((Marshaller)new DisableKeyRotationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableKeyResponse enableKey(EnableKeyRequest enableKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, LimitExceededException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableKeyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EnableKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableKeyRequest).withMarshaller((Marshaller)new EnableKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableKeyRotationResponse enableKeyRotation(EnableKeyRotationRequest enableKeyRotationRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, UnsupportedOperationException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableKeyRotationResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EnableKeyRotationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableKeyRotationRequest).withMarshaller((Marshaller)new EnableKeyRotationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EncryptResponse encrypt(EncryptRequest encryptRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EncryptResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EncryptResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)encryptRequest).withMarshaller((Marshaller)new EncryptRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GenerateDataKeyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GenerateDataKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateDataKeyRequest).withMarshaller((Marshaller)new GenerateDataKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GenerateDataKeyWithoutPlaintextResponse generateDataKeyWithoutPlaintext(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GenerateDataKeyWithoutPlaintextResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GenerateDataKeyWithoutPlaintextResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateDataKeyWithoutPlaintextRequest).withMarshaller((Marshaller)new GenerateDataKeyWithoutPlaintextRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GenerateRandomResponse generateRandom(GenerateRandomRequest generateRandomRequest) throws DependencyTimeoutException, KMSInternalException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GenerateRandomResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GenerateRandomResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateRandomRequest).withMarshaller((Marshaller)new GenerateRandomRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetKeyPolicyResponse getKeyPolicy(GetKeyPolicyRequest getKeyPolicyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetKeyPolicyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetKeyPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKeyPolicyRequest).withMarshaller((Marshaller)new GetKeyPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetKeyRotationStatusResponse getKeyRotationStatus(GetKeyRotationStatusRequest getKeyRotationStatusRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, UnsupportedOperationException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetKeyRotationStatusResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetKeyRotationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKeyRotationStatusRequest).withMarshaller((Marshaller)new GetKeyRotationStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetParametersForImportResponse getParametersForImport(GetParametersForImportRequest getParametersForImportRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetParametersForImportResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetParametersForImportResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getParametersForImportRequest).withMarshaller((Marshaller)new GetParametersForImportRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ImportKeyMaterialResponse importKeyMaterial(ImportKeyMaterialRequest importKeyMaterialRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, InvalidCiphertextException, IncorrectKeyMaterialException, ExpiredImportTokenException, InvalidImportTokenException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportKeyMaterialResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ImportKeyMaterialResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importKeyMaterialRequest).withMarshaller((Marshaller)new ImportKeyMaterialRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws DependencyTimeoutException, InvalidMarkerException, KMSInternalException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAliasesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAliasesRequest).withMarshaller((Marshaller)new ListAliasesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListAliasesPaginator listAliasesIterable(ListAliasesRequest listAliasesRequest) throws DependencyTimeoutException, InvalidMarkerException, KMSInternalException, SdkServiceException, SdkClientException, KMSException {
        return new ListAliasesPaginator(this, listAliasesRequest);
    }

    @Override
    public ListGrantsResponse listGrants(ListGrantsRequest listGrantsRequest) throws NotFoundException, DependencyTimeoutException, InvalidMarkerException, InvalidArnException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGrantsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGrantsRequest).withMarshaller((Marshaller)new ListGrantsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListGrantsPaginator listGrantsIterable(ListGrantsRequest listGrantsRequest) throws NotFoundException, DependencyTimeoutException, InvalidMarkerException, InvalidArnException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        return new ListGrantsPaginator(this, listGrantsRequest);
    }

    @Override
    public ListKeyPoliciesResponse listKeyPolicies(ListKeyPoliciesRequest listKeyPoliciesRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListKeyPoliciesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListKeyPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKeyPoliciesRequest).withMarshaller((Marshaller)new ListKeyPoliciesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListKeyPoliciesPaginator listKeyPoliciesIterable(ListKeyPoliciesRequest listKeyPoliciesRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        return new ListKeyPoliciesPaginator(this, listKeyPoliciesRequest);
    }

    @Override
    public ListKeysResponse listKeys(ListKeysRequest listKeysRequest) throws DependencyTimeoutException, KMSInternalException, InvalidMarkerException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListKeysResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKeysRequest).withMarshaller((Marshaller)new ListKeysRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListKeysPaginator listKeysIterable(ListKeysRequest listKeysRequest) throws DependencyTimeoutException, KMSInternalException, InvalidMarkerException, SdkServiceException, SdkClientException, KMSException {
        return new ListKeysPaginator(this, listKeysRequest);
    }

    @Override
    public ListResourceTagsResponse listResourceTags(ListResourceTagsRequest listResourceTagsRequest) throws KMSInternalException, NotFoundException, InvalidArnException, InvalidMarkerException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResourceTagsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListResourceTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceTagsRequest).withMarshaller((Marshaller)new ListResourceTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListRetirableGrantsResponse listRetirableGrants(ListRetirableGrantsRequest listRetirableGrantsRequest) throws DependencyTimeoutException, InvalidMarkerException, InvalidArnException, NotFoundException, KMSInternalException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRetirableGrantsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListRetirableGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRetirableGrantsRequest).withMarshaller((Marshaller)new ListRetirableGrantsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutKeyPolicyResponse putKeyPolicy(PutKeyPolicyRequest putKeyPolicyRequest) throws NotFoundException, InvalidArnException, MalformedPolicyDocumentException, DependencyTimeoutException, UnsupportedOperationException, KMSInternalException, LimitExceededException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutKeyPolicyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutKeyPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putKeyPolicyRequest).withMarshaller((Marshaller)new PutKeyPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ReEncryptResponse reEncrypt(ReEncryptRequest reEncryptRequest) throws NotFoundException, DisabledException, InvalidCiphertextException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReEncryptResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ReEncryptResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reEncryptRequest).withMarshaller((Marshaller)new ReEncryptRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RetireGrantResponse retireGrant(RetireGrantRequest retireGrantRequest) throws InvalidGrantTokenException, InvalidGrantIdException, NotFoundException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RetireGrantResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RetireGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)retireGrantRequest).withMarshaller((Marshaller)new RetireGrantRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RevokeGrantResponse revokeGrant(RevokeGrantRequest revokeGrantRequest) throws NotFoundException, DependencyTimeoutException, InvalidArnException, InvalidGrantIdException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RevokeGrantResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RevokeGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeGrantRequest).withMarshaller((Marshaller)new RevokeGrantRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ScheduleKeyDeletionResponse scheduleKeyDeletion(ScheduleKeyDeletionRequest scheduleKeyDeletionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ScheduleKeyDeletionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ScheduleKeyDeletionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)scheduleKeyDeletionRequest).withMarshaller((Marshaller)new ScheduleKeyDeletionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws KMSInternalException, NotFoundException, InvalidArnException, KMSInvalidStateException, LimitExceededException, TagException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws KMSInternalException, NotFoundException, InvalidArnException, KMSInvalidStateException, TagException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAliasResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAliasRequest).withMarshaller((Marshaller)new UpdateAliasRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateKeyDescriptionResponse updateKeyDescription(UpdateKeyDescriptionRequest updateKeyDescriptionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkServiceException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateKeyDescriptionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateKeyDescriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateKeyDescriptionRequest).withMarshaller((Marshaller)new UpdateKeyDescriptionRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(KMSException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredImportTokenException").withModeledClass(ExpiredImportTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MalformedPolicyDocumentException").withModeledClass(MalformedPolicyDocumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncorrectKeyMaterialException").withModeledClass(IncorrectKeyMaterialException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidImportTokenException").withModeledClass(InvalidImportTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArnException").withModeledClass(InvalidArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInvalidStateException").withModeledClass(KMSInvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DisabledException").withModeledClass(DisabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KeyUnavailableException").withModeledClass(KeyUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCiphertextException").withModeledClass(InvalidCiphertextException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidGrantIdException").withModeledClass(InvalidGrantIdException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidGrantTokenException").withModeledClass(InvalidGrantTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperationException").withModeledClass(UnsupportedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyExistsException").withModeledClass(AlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagException").withModeledClass(TagException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidKeyUsageException").withModeledClass(InvalidKeyUsageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidMarkerException").withModeledClass(InvalidMarkerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAliasNameException").withModeledClass(InvalidAliasNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyTimeoutException").withModeledClass(DependencyTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInternalException").withModeledClass(KMSInternalException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

