/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kms.model.KMSRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelKeyDeletionRequest
extends KMSRequest
implements ToCopyableBuilder<Builder, CancelKeyDeletionRequest> {
    private final String keyId;

    private CancelKeyDeletionRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
    }

    public String keyId() {
        return this.keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelKeyDeletionRequest)) {
            return false;
        }
        CancelKeyDeletionRequest other = (CancelKeyDeletionRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KMSRequest.BuilderImpl
    implements Builder {
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelKeyDeletionRequest model) {
            this.keyId(model.keyId);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CancelKeyDeletionRequest build() {
            return new CancelKeyDeletionRequest(this);
        }
    }

    public static interface Builder
    extends KMSRequest.Builder,
    CopyableBuilder<Builder, CancelKeyDeletionRequest> {
        public Builder keyId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

