/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.GrantConstraints;

@SdkInternalApi
public class GrantConstraintsMarshaller {
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXTSUBSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContextSubset").build();
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXTEQUALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContextEquals").build();
    private static final GrantConstraintsMarshaller INSTANCE = new GrantConstraintsMarshaller();

    public static GrantConstraintsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GrantConstraints grantConstraints, ProtocolMarshaller protocolMarshaller) {
        if (grantConstraints == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(grantConstraints.encryptionContextSubset(), ENCRYPTIONCONTEXTSUBSET_BINDING);
            protocolMarshaller.marshall(grantConstraints.encryptionContextEquals(), ENCRYPTIONCONTEXTEQUALS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

