/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParametersForImportResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetParametersForImportResponse> {
    private final String keyId;
    private final ByteBuffer importToken;
    private final ByteBuffer publicKey;
    private final Instant parametersValidTo;

    private GetParametersForImportResponse(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.importToken = builder.importToken;
        this.publicKey = builder.publicKey;
        this.parametersValidTo = builder.parametersValidTo;
    }

    public String keyId() {
        return this.keyId;
    }

    public ByteBuffer importToken() {
        return this.importToken == null ? null : this.importToken.asReadOnlyBuffer();
    }

    public ByteBuffer publicKey() {
        return this.publicKey == null ? null : this.publicKey.asReadOnlyBuffer();
    }

    public Instant parametersValidTo() {
        return this.parametersValidTo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.parametersValidTo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportResponse)) {
            return false;
        }
        GetParametersForImportResponse other = (GetParametersForImportResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.importToken(), other.importToken()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.parametersValidTo(), other.parametersValidTo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.importToken() != null) {
            sb.append("ImportToken: ").append(this.importToken()).append(",");
        }
        if (this.publicKey() != null) {
            sb.append("PublicKey: ").append(this.publicKey()).append(",");
        }
        if (this.parametersValidTo() != null) {
            sb.append("ParametersValidTo: ").append(this.parametersValidTo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "ImportToken": {
                return Optional.of(clazz.cast(this.importToken()));
            }
            case "PublicKey": {
                return Optional.of(clazz.cast(this.publicKey()));
            }
            case "ParametersValidTo": {
                return Optional.of(clazz.cast(this.parametersValidTo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private ByteBuffer importToken;
        private ByteBuffer publicKey;
        private Instant parametersValidTo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportResponse model) {
            this.keyId(model.keyId);
            this.importToken(model.importToken);
            this.publicKey(model.publicKey);
            this.parametersValidTo(model.parametersValidTo);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getImportToken() {
            return this.importToken;
        }

        @Override
        public final Builder importToken(ByteBuffer importToken) {
            this.importToken = StandardMemberCopier.copy((ByteBuffer)importToken);
            return this;
        }

        public final void setImportToken(ByteBuffer importToken) {
            this.importToken = StandardMemberCopier.copy((ByteBuffer)importToken);
        }

        public final ByteBuffer getPublicKey() {
            return this.publicKey;
        }

        @Override
        public final Builder publicKey(ByteBuffer publicKey) {
            this.publicKey = StandardMemberCopier.copy((ByteBuffer)publicKey);
            return this;
        }

        public final void setPublicKey(ByteBuffer publicKey) {
            this.publicKey = StandardMemberCopier.copy((ByteBuffer)publicKey);
        }

        public final Instant getParametersValidTo() {
            return this.parametersValidTo;
        }

        @Override
        public final Builder parametersValidTo(Instant parametersValidTo) {
            this.parametersValidTo = parametersValidTo;
            return this;
        }

        public final void setParametersValidTo(Instant parametersValidTo) {
            this.parametersValidTo = parametersValidTo;
        }

        public GetParametersForImportResponse build() {
            return new GetParametersForImportResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetParametersForImportResponse> {
        public Builder keyId(String var1);

        public Builder importToken(ByteBuffer var1);

        public Builder publicKey(ByteBuffer var1);

        public Builder parametersValidTo(Instant var1);
    }
}

