/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.AliasListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AliasListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, AliasListEntry> {
    private final String aliasName;
    private final String aliasArn;
    private final String targetKeyId;

    private AliasListEntry(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.aliasArn = builder.aliasArn;
        this.targetKeyId = builder.targetKeyId;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public String aliasArn() {
        return this.aliasArn;
    }

    public String targetKeyId() {
        return this.targetKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasListEntry)) {
            return false;
        }
        AliasListEntry other = (AliasListEntry)obj;
        return Objects.equals(this.aliasName(), other.aliasName()) && Objects.equals(this.aliasArn(), other.aliasArn()) && Objects.equals(this.targetKeyId(), other.targetKeyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.aliasName() != null) {
            sb.append("AliasName: ").append(this.aliasName()).append(",");
        }
        if (this.aliasArn() != null) {
            sb.append("AliasArn: ").append(this.aliasArn()).append(",");
        }
        if (this.targetKeyId() != null) {
            sb.append("TargetKeyId: ").append(this.targetKeyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasName": {
                return Optional.of(clazz.cast(this.aliasName()));
            }
            case "AliasArn": {
                return Optional.of(clazz.cast(this.aliasArn()));
            }
            case "TargetKeyId": {
                return Optional.of(clazz.cast(this.targetKeyId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AliasListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String aliasName;
        private String aliasArn;
        private String targetKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasListEntry model) {
            this.aliasName(model.aliasName);
            this.aliasArn(model.aliasArn);
            this.targetKeyId(model.targetKeyId);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final String getAliasArn() {
            return this.aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getTargetKeyId() {
            return this.targetKeyId;
        }

        @Override
        public final Builder targetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
            return this;
        }

        public final void setTargetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
        }

        public AliasListEntry build() {
            return new AliasListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AliasListEntry> {
        public Builder aliasName(String var1);

        public Builder aliasArn(String var1);

        public Builder targetKeyId(String var1);
    }
}

