/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.transform.GrantConstraintsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GrantConstraints
implements StructuredPojo,
ToCopyableBuilder<Builder, GrantConstraints> {
    private final Map<String, String> encryptionContextSubset;
    private final Map<String, String> encryptionContextEquals;

    private GrantConstraints(BuilderImpl builder) {
        this.encryptionContextSubset = builder.encryptionContextSubset;
        this.encryptionContextEquals = builder.encryptionContextEquals;
    }

    public Map<String, String> encryptionContextSubset() {
        return this.encryptionContextSubset;
    }

    public Map<String, String> encryptionContextEquals() {
        return this.encryptionContextEquals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.encryptionContextSubset() == null ? 0 : this.encryptionContextSubset().hashCode());
        hashCode = 31 * hashCode + (this.encryptionContextEquals() == null ? 0 : this.encryptionContextEquals().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantConstraints)) {
            return false;
        }
        GrantConstraints other = (GrantConstraints)obj;
        if (other.encryptionContextSubset() == null ^ this.encryptionContextSubset() == null) {
            return false;
        }
        if (other.encryptionContextSubset() != null && !other.encryptionContextSubset().equals(this.encryptionContextSubset())) {
            return false;
        }
        if (other.encryptionContextEquals() == null ^ this.encryptionContextEquals() == null) {
            return false;
        }
        return other.encryptionContextEquals() == null || other.encryptionContextEquals().equals(this.encryptionContextEquals());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.encryptionContextSubset() != null) {
            sb.append("EncryptionContextSubset: ").append(this.encryptionContextSubset()).append(",");
        }
        if (this.encryptionContextEquals() != null) {
            sb.append("EncryptionContextEquals: ").append(this.encryptionContextEquals()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionContextSubset": {
                return Optional.of(clazz.cast(this.encryptionContextSubset()));
            }
            case "EncryptionContextEquals": {
                return Optional.of(clazz.cast(this.encryptionContextEquals()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GrantConstraintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> encryptionContextSubset;
        private Map<String, String> encryptionContextEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantConstraints model) {
            this.encryptionContextSubset(model.encryptionContextSubset);
            this.encryptionContextEquals(model.encryptionContextEquals);
        }

        public final Map<String, String> getEncryptionContextSubset() {
            return this.encryptionContextSubset;
        }

        @Override
        public final Builder encryptionContextSubset(Map<String, String> encryptionContextSubset) {
            this.encryptionContextSubset = EncryptionContextTypeCopier.copy(encryptionContextSubset);
            return this;
        }

        public final void setEncryptionContextSubset(Map<String, String> encryptionContextSubset) {
            this.encryptionContextSubset = EncryptionContextTypeCopier.copy(encryptionContextSubset);
        }

        public final Map<String, String> getEncryptionContextEquals() {
            return this.encryptionContextEquals;
        }

        @Override
        public final Builder encryptionContextEquals(Map<String, String> encryptionContextEquals) {
            this.encryptionContextEquals = EncryptionContextTypeCopier.copy(encryptionContextEquals);
            return this;
        }

        public final void setEncryptionContextEquals(Map<String, String> encryptionContextEquals) {
            this.encryptionContextEquals = EncryptionContextTypeCopier.copy(encryptionContextEquals);
        }

        public GrantConstraints build() {
            return new GrantConstraints(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GrantConstraints> {
        public Builder encryptionContextSubset(Map<String, String> var1);

        public Builder encryptionContextEquals(Map<String, String> var1);
    }
}

