/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.model.ExpirationModelType;
import software.amazon.awssdk.services.kms.model.KeyState;
import software.amazon.awssdk.services.kms.model.KeyUsageType;
import software.amazon.awssdk.services.kms.model.OriginType;
import software.amazon.awssdk.services.kms.transform.KeyMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeyMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, KeyMetadata> {
    private final String awsAccountId;
    private final String keyId;
    private final String arn;
    private final Instant creationDate;
    private final Boolean enabled;
    private final String description;
    private final String keyUsage;
    private final String keyState;
    private final Instant deletionDate;
    private final Instant validTo;
    private final String origin;
    private final String expirationModel;

    private KeyMetadata(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.keyId = builder.keyId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.enabled = builder.enabled;
        this.description = builder.description;
        this.keyUsage = builder.keyUsage;
        this.keyState = builder.keyState;
        this.deletionDate = builder.deletionDate;
        this.validTo = builder.validTo;
        this.origin = builder.origin;
        this.expirationModel = builder.expirationModel;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String keyId() {
        return this.keyId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String description() {
        return this.description;
    }

    public String keyUsage() {
        return this.keyUsage;
    }

    public String keyState() {
        return this.keyState;
    }

    public Instant deletionDate() {
        return this.deletionDate;
    }

    public Instant validTo() {
        return this.validTo;
    }

    public String origin() {
        return this.origin;
    }

    public String expirationModel() {
        return this.expirationModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.awsAccountId() == null ? 0 : this.awsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.keyUsage() == null ? 0 : this.keyUsage().hashCode());
        hashCode = 31 * hashCode + (this.keyState() == null ? 0 : this.keyState().hashCode());
        hashCode = 31 * hashCode + (this.deletionDate() == null ? 0 : this.deletionDate().hashCode());
        hashCode = 31 * hashCode + (this.validTo() == null ? 0 : this.validTo().hashCode());
        hashCode = 31 * hashCode + (this.origin() == null ? 0 : this.origin().hashCode());
        hashCode = 31 * hashCode + (this.expirationModel() == null ? 0 : this.expirationModel().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyMetadata)) {
            return false;
        }
        KeyMetadata other = (KeyMetadata)obj;
        if (other.awsAccountId() == null ^ this.awsAccountId() == null) {
            return false;
        }
        if (other.awsAccountId() != null && !other.awsAccountId().equals(this.awsAccountId())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.keyUsage() == null ^ this.keyUsage() == null) {
            return false;
        }
        if (other.keyUsage() != null && !other.keyUsage().equals(this.keyUsage())) {
            return false;
        }
        if (other.keyState() == null ^ this.keyState() == null) {
            return false;
        }
        if (other.keyState() != null && !other.keyState().equals(this.keyState())) {
            return false;
        }
        if (other.deletionDate() == null ^ this.deletionDate() == null) {
            return false;
        }
        if (other.deletionDate() != null && !other.deletionDate().equals(this.deletionDate())) {
            return false;
        }
        if (other.validTo() == null ^ this.validTo() == null) {
            return false;
        }
        if (other.validTo() != null && !other.validTo().equals(this.validTo())) {
            return false;
        }
        if (other.origin() == null ^ this.origin() == null) {
            return false;
        }
        if (other.origin() != null && !other.origin().equals(this.origin())) {
            return false;
        }
        if (other.expirationModel() == null ^ this.expirationModel() == null) {
            return false;
        }
        return other.expirationModel() == null || other.expirationModel().equals(this.expirationModel());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.awsAccountId() != null) {
            sb.append("AWSAccountId: ").append(this.awsAccountId()).append(",");
        }
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.keyUsage() != null) {
            sb.append("KeyUsage: ").append(this.keyUsage()).append(",");
        }
        if (this.keyState() != null) {
            sb.append("KeyState: ").append(this.keyState()).append(",");
        }
        if (this.deletionDate() != null) {
            sb.append("DeletionDate: ").append(this.deletionDate()).append(",");
        }
        if (this.validTo() != null) {
            sb.append("ValidTo: ").append(this.validTo()).append(",");
        }
        if (this.origin() != null) {
            sb.append("Origin: ").append(this.origin()).append(",");
        }
        if (this.expirationModel() != null) {
            sb.append("ExpirationModel: ").append(this.expirationModel()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String keyId;
        private String arn;
        private Instant creationDate;
        private Boolean enabled;
        private String description;
        private String keyUsage;
        private String keyState;
        private Instant deletionDate;
        private Instant validTo;
        private String origin;
        private String expirationModel;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyMetadata model) {
            this.setAWSAccountId(model.awsAccountId);
            this.setKeyId(model.keyId);
            this.setArn(model.arn);
            this.setCreationDate(model.creationDate);
            this.setEnabled(model.enabled);
            this.setDescription(model.description);
            this.setKeyUsage(model.keyUsage);
            this.setKeyState(model.keyState);
            this.setDeletionDate(model.deletionDate);
            this.setValidTo(model.validTo);
            this.setOrigin(model.origin);
            this.setExpirationModel(model.expirationModel);
        }

        public final String getAWSAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAWSAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKeyUsage() {
            return this.keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
            return this;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        public final String getKeyState() {
            return this.keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState.toString());
            return this;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public final Instant getValidTo() {
            return this.validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        public final String getOrigin() {
            return this.origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginType origin) {
            this.origin(origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final String getExpirationModel() {
            return this.expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel.toString());
            return this;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        public KeyMetadata build() {
            return new KeyMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyMetadata> {
        public Builder awsAccountId(String var1);

        public Builder keyId(String var1);

        public Builder arn(String var1);

        public Builder creationDate(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder description(String var1);

        public Builder keyUsage(String var1);

        public Builder keyUsage(KeyUsageType var1);

        public Builder keyState(String var1);

        public Builder keyState(KeyState var1);

        public Builder deletionDate(Instant var1);

        public Builder validTo(Instant var1);

        public Builder origin(String var1);

        public Builder origin(OriginType var1);

        public Builder expirationModel(String var1);

        public Builder expirationModel(ExpirationModelType var1);
    }
}

