/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateDataKeyWithoutPlaintextResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GenerateDataKeyWithoutPlaintextResponse> {
    private final ByteBuffer ciphertextBlob;
    private final String keyId;

    private GenerateDataKeyWithoutPlaintextResponse(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.keyId = builder.keyId;
    }

    public ByteBuffer ciphertextBlob() {
        return this.ciphertextBlob == null ? null : this.ciphertextBlob.asReadOnlyBuffer();
    }

    public String keyId() {
        return this.keyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ciphertextBlob() == null ? 0 : this.ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyWithoutPlaintextResponse)) {
            return false;
        }
        GenerateDataKeyWithoutPlaintextResponse other = (GenerateDataKeyWithoutPlaintextResponse)((Object)obj);
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        return other.keyId() == null || other.keyId().equals(this.keyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(this.ciphertextBlob()).append(",");
        }
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ByteBuffer ciphertextBlob;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyWithoutPlaintextResponse model) {
            this.setCiphertextBlob(model.ciphertextBlob);
            this.setKeyId(model.keyId);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public GenerateDataKeyWithoutPlaintextResponse build() {
            return new GenerateDataKeyWithoutPlaintextResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenerateDataKeyWithoutPlaintextResponse> {
        public Builder ciphertextBlob(ByteBuffer var1);

        public Builder keyId(String var1);
    }
}

