/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.AlreadyExistsException;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.CreateAliasRequest;
import software.amazon.awssdk.services.kms.model.CreateAliasResponse;
import software.amazon.awssdk.services.kms.model.CreateGrantRequest;
import software.amazon.awssdk.services.kms.model.CreateGrantResponse;
import software.amazon.awssdk.services.kms.model.CreateKeyRequest;
import software.amazon.awssdk.services.kms.model.CreateKeyResponse;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DeleteAliasRequest;
import software.amazon.awssdk.services.kms.model.DeleteAliasResponse;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.DependencyTimeoutException;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.DisabledException;
import software.amazon.awssdk.services.kms.model.EnableKeyRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyResponse;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.ExpiredImportTokenException;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse;
import software.amazon.awssdk.services.kms.model.GenerateRandomRequest;
import software.amazon.awssdk.services.kms.model.GenerateRandomResponse;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse;
import software.amazon.awssdk.services.kms.model.GetParametersForImportRequest;
import software.amazon.awssdk.services.kms.model.GetParametersForImportResponse;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.IncorrectKeyMaterialException;
import software.amazon.awssdk.services.kms.model.InvalidAliasNameException;
import software.amazon.awssdk.services.kms.model.InvalidArnException;
import software.amazon.awssdk.services.kms.model.InvalidCiphertextException;
import software.amazon.awssdk.services.kms.model.InvalidGrantIdException;
import software.amazon.awssdk.services.kms.model.InvalidGrantTokenException;
import software.amazon.awssdk.services.kms.model.InvalidImportTokenException;
import software.amazon.awssdk.services.kms.model.InvalidKeyUsageException;
import software.amazon.awssdk.services.kms.model.InvalidMarkerException;
import software.amazon.awssdk.services.kms.model.KMSException;
import software.amazon.awssdk.services.kms.model.KMSInternalException;
import software.amazon.awssdk.services.kms.model.KMSInvalidStateException;
import software.amazon.awssdk.services.kms.model.KeyUnavailableException;
import software.amazon.awssdk.services.kms.model.LimitExceededException;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;
import software.amazon.awssdk.services.kms.model.ListResourceTagsRequest;
import software.amazon.awssdk.services.kms.model.ListResourceTagsResponse;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse;
import software.amazon.awssdk.services.kms.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.kms.model.NotFoundException;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.ReEncryptRequest;
import software.amazon.awssdk.services.kms.model.ReEncryptResponse;
import software.amazon.awssdk.services.kms.model.RetireGrantRequest;
import software.amazon.awssdk.services.kms.model.RetireGrantResponse;
import software.amazon.awssdk.services.kms.model.RevokeGrantRequest;
import software.amazon.awssdk.services.kms.model.RevokeGrantResponse;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.TagException;
import software.amazon.awssdk.services.kms.model.TagResourceRequest;
import software.amazon.awssdk.services.kms.model.TagResourceResponse;
import software.amazon.awssdk.services.kms.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kms.model.UntagResourceRequest;
import software.amazon.awssdk.services.kms.model.UntagResourceResponse;
import software.amazon.awssdk.services.kms.model.UpdateAliasRequest;
import software.amazon.awssdk.services.kms.model.UpdateAliasResponse;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionResponse;
import software.amazon.awssdk.services.kms.transform.CancelKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CancelKeyDeletionResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateAliasResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.CreateGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateGrantResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.CreateKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DecryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DecryptResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteAliasResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteImportedKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteImportedKeyMaterialResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRotationResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRotationResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.EncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EncryptResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyWithoutPlaintextRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyWithoutPlaintextResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateRandomRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateRandomResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyRotationStatusRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyRotationStatusResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.GetParametersForImportRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetParametersForImportResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ImportKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ImportKeyMaterialResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListAliasesResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListGrantsResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyPoliciesResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeysRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeysResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListResourceTagsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListResourceTagsResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ListRetirableGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListRetirableGrantsResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.PutKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.PutKeyPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ReEncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ReEncryptResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.RetireGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RetireGrantResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.RevokeGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RevokeGrantResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.ScheduleKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ScheduleKeyDeletionResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateAliasResponseUnmarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateKeyDescriptionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateKeyDescriptionResponseUnmarshaller;

@SdkInternalApi
final class DefaultKMSClient
implements KMSClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultKMSClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public CancelKeyDeletionResponse cancelKeyDeletion(CancelKeyDeletionRequest cancelKeyDeletionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CancelKeyDeletionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CancelKeyDeletionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)cancelKeyDeletionRequest).withMarshaller((Marshaller)new CancelKeyDeletionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws DependencyTimeoutException, AlreadyExistsException, NotFoundException, InvalidAliasNameException, KMSInternalException, LimitExceededException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateAliasResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateAliasResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createAliasRequest).withMarshaller((Marshaller)new CreateAliasRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateGrantResponse createGrant(CreateGrantRequest createGrantRequest) throws NotFoundException, DisabledException, DependencyTimeoutException, InvalidArnException, KMSInternalException, InvalidGrantTokenException, LimitExceededException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateGrantResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateGrantResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createGrantRequest).withMarshaller((Marshaller)new CreateGrantRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateKeyResponse createKey() throws MalformedPolicyDocumentException, DependencyTimeoutException, InvalidArnException, UnsupportedOperationException, KMSInternalException, LimitExceededException, TagException, SdkBaseException, SdkClientException, KMSException {
        return this.createKey((CreateKeyRequest)((Object)CreateKeyRequest.builder().build()));
    }

    @Override
    public CreateKeyResponse createKey(CreateKeyRequest createKeyRequest) throws MalformedPolicyDocumentException, DependencyTimeoutException, InvalidArnException, UnsupportedOperationException, KMSInternalException, LimitExceededException, TagException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateKeyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateKeyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createKeyRequest).withMarshaller((Marshaller)new CreateKeyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DecryptResponse decrypt(DecryptRequest decryptRequest) throws NotFoundException, DisabledException, InvalidCiphertextException, KeyUnavailableException, DependencyTimeoutException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DecryptResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DecryptResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)decryptRequest).withMarshaller((Marshaller)new DecryptRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteAliasResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteAliasResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteAliasRequest).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteImportedKeyMaterialResponse deleteImportedKeyMaterial(DeleteImportedKeyMaterialRequest deleteImportedKeyMaterialRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteImportedKeyMaterialResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteImportedKeyMaterialResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteImportedKeyMaterialRequest).withMarshaller((Marshaller)new DeleteImportedKeyMaterialRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeKeyResponse describeKey(DescribeKeyRequest describeKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeKeyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeKeyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeKeyRequest).withMarshaller((Marshaller)new DescribeKeyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DisableKeyResponse disableKey(DisableKeyRequest disableKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DisableKeyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisableKeyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)disableKeyRequest).withMarshaller((Marshaller)new DisableKeyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DisableKeyRotationResponse disableKeyRotation(DisableKeyRotationRequest disableKeyRotationRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, UnsupportedOperationException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DisableKeyRotationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisableKeyRotationResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)disableKeyRotationRequest).withMarshaller((Marshaller)new DisableKeyRotationRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public EnableKeyResponse enableKey(EnableKeyRequest enableKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, LimitExceededException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new EnableKeyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EnableKeyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)enableKeyRequest).withMarshaller((Marshaller)new EnableKeyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public EnableKeyRotationResponse enableKeyRotation(EnableKeyRotationRequest enableKeyRotationRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, UnsupportedOperationException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new EnableKeyRotationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EnableKeyRotationResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)enableKeyRotationRequest).withMarshaller((Marshaller)new EnableKeyRotationRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public EncryptResponse encrypt(EncryptRequest encryptRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new EncryptResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EncryptResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)encryptRequest).withMarshaller((Marshaller)new EncryptRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GenerateDataKeyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GenerateDataKeyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)generateDataKeyRequest).withMarshaller((Marshaller)new GenerateDataKeyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GenerateDataKeyWithoutPlaintextResponse generateDataKeyWithoutPlaintext(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GenerateDataKeyWithoutPlaintextResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GenerateDataKeyWithoutPlaintextResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)generateDataKeyWithoutPlaintextRequest).withMarshaller((Marshaller)new GenerateDataKeyWithoutPlaintextRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GenerateRandomResponse generateRandom() throws DependencyTimeoutException, KMSInternalException, SdkBaseException, SdkClientException, KMSException {
        return this.generateRandom((GenerateRandomRequest)((Object)GenerateRandomRequest.builder().build()));
    }

    @Override
    public GenerateRandomResponse generateRandom(GenerateRandomRequest generateRandomRequest) throws DependencyTimeoutException, KMSInternalException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GenerateRandomResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GenerateRandomResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)generateRandomRequest).withMarshaller((Marshaller)new GenerateRandomRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetKeyPolicyResponse getKeyPolicy(GetKeyPolicyRequest getKeyPolicyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetKeyPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetKeyPolicyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getKeyPolicyRequest).withMarshaller((Marshaller)new GetKeyPolicyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetKeyRotationStatusResponse getKeyRotationStatus(GetKeyRotationStatusRequest getKeyRotationStatusRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, UnsupportedOperationException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetKeyRotationStatusResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetKeyRotationStatusResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getKeyRotationStatusRequest).withMarshaller((Marshaller)new GetKeyRotationStatusRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetParametersForImportResponse getParametersForImport(GetParametersForImportRequest getParametersForImportRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetParametersForImportResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetParametersForImportResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getParametersForImportRequest).withMarshaller((Marshaller)new GetParametersForImportRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ImportKeyMaterialResponse importKeyMaterial(ImportKeyMaterialRequest importKeyMaterialRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, InvalidCiphertextException, IncorrectKeyMaterialException, ExpiredImportTokenException, InvalidImportTokenException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ImportKeyMaterialResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ImportKeyMaterialResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)importKeyMaterialRequest).withMarshaller((Marshaller)new ImportKeyMaterialRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListAliasesResponse listAliases() throws DependencyTimeoutException, InvalidMarkerException, KMSInternalException, SdkBaseException, SdkClientException, KMSException {
        return this.listAliases((ListAliasesRequest)((Object)ListAliasesRequest.builder().build()));
    }

    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws DependencyTimeoutException, InvalidMarkerException, KMSInternalException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListAliasesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListAliasesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listAliasesRequest).withMarshaller((Marshaller)new ListAliasesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListGrantsResponse listGrants(ListGrantsRequest listGrantsRequest) throws NotFoundException, DependencyTimeoutException, InvalidMarkerException, InvalidArnException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListGrantsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListGrantsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listGrantsRequest).withMarshaller((Marshaller)new ListGrantsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListKeyPoliciesResponse listKeyPolicies(ListKeyPoliciesRequest listKeyPoliciesRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListKeyPoliciesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListKeyPoliciesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listKeyPoliciesRequest).withMarshaller((Marshaller)new ListKeyPoliciesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListKeysResponse listKeys() throws DependencyTimeoutException, KMSInternalException, InvalidMarkerException, SdkBaseException, SdkClientException, KMSException {
        return this.listKeys((ListKeysRequest)((Object)ListKeysRequest.builder().build()));
    }

    @Override
    public ListKeysResponse listKeys(ListKeysRequest listKeysRequest) throws DependencyTimeoutException, KMSInternalException, InvalidMarkerException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListKeysResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListKeysResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listKeysRequest).withMarshaller((Marshaller)new ListKeysRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListResourceTagsResponse listResourceTags(ListResourceTagsRequest listResourceTagsRequest) throws KMSInternalException, NotFoundException, InvalidArnException, InvalidMarkerException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListResourceTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListResourceTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listResourceTagsRequest).withMarshaller((Marshaller)new ListResourceTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListRetirableGrantsResponse listRetirableGrants(ListRetirableGrantsRequest listRetirableGrantsRequest) throws DependencyTimeoutException, InvalidMarkerException, InvalidArnException, NotFoundException, KMSInternalException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListRetirableGrantsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListRetirableGrantsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listRetirableGrantsRequest).withMarshaller((Marshaller)new ListRetirableGrantsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public PutKeyPolicyResponse putKeyPolicy(PutKeyPolicyRequest putKeyPolicyRequest) throws NotFoundException, InvalidArnException, MalformedPolicyDocumentException, DependencyTimeoutException, UnsupportedOperationException, KMSInternalException, LimitExceededException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PutKeyPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutKeyPolicyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)putKeyPolicyRequest).withMarshaller((Marshaller)new PutKeyPolicyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ReEncryptResponse reEncrypt(ReEncryptRequest reEncryptRequest) throws NotFoundException, DisabledException, InvalidCiphertextException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ReEncryptResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ReEncryptResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)reEncryptRequest).withMarshaller((Marshaller)new ReEncryptRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RetireGrantResponse retireGrant() throws InvalidGrantTokenException, InvalidGrantIdException, NotFoundException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        return this.retireGrant((RetireGrantRequest)((Object)RetireGrantRequest.builder().build()));
    }

    @Override
    public RetireGrantResponse retireGrant(RetireGrantRequest retireGrantRequest) throws InvalidGrantTokenException, InvalidGrantIdException, NotFoundException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RetireGrantResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RetireGrantResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)retireGrantRequest).withMarshaller((Marshaller)new RetireGrantRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RevokeGrantResponse revokeGrant(RevokeGrantRequest revokeGrantRequest) throws NotFoundException, DependencyTimeoutException, InvalidArnException, InvalidGrantIdException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RevokeGrantResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RevokeGrantResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)revokeGrantRequest).withMarshaller((Marshaller)new RevokeGrantRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ScheduleKeyDeletionResponse scheduleKeyDeletion(ScheduleKeyDeletionRequest scheduleKeyDeletionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ScheduleKeyDeletionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ScheduleKeyDeletionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)scheduleKeyDeletionRequest).withMarshaller((Marshaller)new ScheduleKeyDeletionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws KMSInternalException, NotFoundException, InvalidArnException, KMSInvalidStateException, LimitExceededException, TagException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new TagResourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TagResourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws KMSInternalException, NotFoundException, InvalidArnException, KMSInvalidStateException, TagException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UntagResourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UntagResourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws DependencyTimeoutException, NotFoundException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateAliasResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateAliasResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateAliasRequest).withMarshaller((Marshaller)new UpdateAliasRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateKeyDescriptionResponse updateKeyDescription(UpdateKeyDescriptionRequest updateKeyDescriptionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KMSInternalException, KMSInvalidStateException, SdkBaseException, SdkClientException, KMSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateKeyDescriptionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateKeyDescriptionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateKeyDescriptionRequest).withMarshaller((Marshaller)new UpdateKeyDescriptionRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(KMSException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredImportTokenException").withModeledClass(ExpiredImportTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MalformedPolicyDocumentException").withModeledClass(MalformedPolicyDocumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncorrectKeyMaterialException").withModeledClass(IncorrectKeyMaterialException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidImportTokenException").withModeledClass(InvalidImportTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArnException").withModeledClass(InvalidArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInvalidStateException").withModeledClass(KMSInvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DisabledException").withModeledClass(DisabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KeyUnavailableException").withModeledClass(KeyUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCiphertextException").withModeledClass(InvalidCiphertextException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidGrantIdException").withModeledClass(InvalidGrantIdException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidGrantTokenException").withModeledClass(InvalidGrantTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperationException").withModeledClass(UnsupportedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyExistsException").withModeledClass(AlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagException").withModeledClass(TagException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidKeyUsageException").withModeledClass(InvalidKeyUsageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidMarkerException").withModeledClass(InvalidMarkerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAliasNameException").withModeledClass(InvalidAliasNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyTimeoutException").withModeledClass(DependencyTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInternalException").withModeledClass(KMSInternalException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

