/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.transform;

import java.math.*;
import java.nio.ByteBuffer;
import javax.annotation.Generated;

import software.amazon.awssdk.services.kms.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetParametersForImportResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetParametersForImportResponseUnmarshaller implements
        Unmarshaller<GetParametersForImportResponse, JsonUnmarshallerContext> {

    public GetParametersForImportResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetParametersForImportResponse.Builder getParametersForImportResponseBuilder = GetParametersForImportResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getParametersForImportResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    getParametersForImportResponseBuilder.keyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ImportToken", targetDepth)) {
                    context.nextToken();
                    getParametersForImportResponseBuilder.importToken(context.getUnmarshaller(java.nio.ByteBuffer.class)
                            .unmarshall(context));
                }
                if (context.testExpression("PublicKey", targetDepth)) {
                    context.nextToken();
                    getParametersForImportResponseBuilder.publicKey(context.getUnmarshaller(java.nio.ByteBuffer.class)
                            .unmarshall(context));
                }
                if (context.testExpression("ParametersValidTo", targetDepth)) {
                    context.nextToken();
                    getParametersForImportResponseBuilder.parametersValidTo(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getParametersForImportResponseBuilder.build();
    }

    private static GetParametersForImportResponseUnmarshaller INSTANCE;

    public static GetParametersForImportResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new GetParametersForImportResponseUnmarshaller();
        return INSTANCE;
    }
}
