/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.transform;

import java.util.Map;
import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.kms.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * DecryptRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class DecryptRequestModelMarshaller {

    private static final MarshallingInfo<java.nio.ByteBuffer> CIPHERTEXTBLOB_BINDING = MarshallingInfo
            .builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CiphertextBlob").build();
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXT_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContext").build();
    private static final MarshallingInfo<List> GRANTTOKENS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTokens").build();

    private static final DecryptRequestModelMarshaller instance = new DecryptRequestModelMarshaller();

    public static DecryptRequestModelMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DecryptRequest decryptRequest, ProtocolMarshaller protocolMarshaller) {

        if (decryptRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(decryptRequest.ciphertextBlob(), CIPHERTEXTBLOB_BINDING);

            protocolMarshaller.marshall(decryptRequest.encryptionContext(), ENCRYPTIONCONTEXT_BINDING);

            protocolMarshaller.marshall(decryptRequest.grantTokens(), GRANTTOKENS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
