/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduleKeyDeletionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ScheduleKeyDeletionResponse.Builder, ScheduleKeyDeletionResponse> {
    private final String keyId;

    private final Instant deletionDate;

    private ScheduleKeyDeletionResponse(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.deletionDate = builder.deletionDate;
    }

    /**
     * <p>
     * The unique identifier of the customer master key (CMK) for which deletion is scheduled.
     * </p>
     * 
     * @return The unique identifier of the customer master key (CMK) for which deletion is scheduled.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The date and time after which AWS KMS deletes the customer master key (CMK).
     * </p>
     * 
     * @return The date and time after which AWS KMS deletes the customer master key (CMK).
     */
    public Instant deletionDate() {
        return deletionDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((deletionDate() == null) ? 0 : deletionDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleKeyDeletionResponse)) {
            return false;
        }
        ScheduleKeyDeletionResponse other = (ScheduleKeyDeletionResponse) obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.deletionDate() == null ^ this.deletionDate() == null) {
            return false;
        }
        if (other.deletionDate() != null && !other.deletionDate().equals(this.deletionDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (deletionDate() != null) {
            sb.append("DeletionDate: ").append(deletionDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleKeyDeletionResponse> {
        /**
         * <p>
         * The unique identifier of the customer master key (CMK) for which deletion is scheduled.
         * </p>
         * 
         * @param keyId
         *        The unique identifier of the customer master key (CMK) for which deletion is scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The date and time after which AWS KMS deletes the customer master key (CMK).
         * </p>
         * 
         * @param deletionDate
         *        The date and time after which AWS KMS deletes the customer master key (CMK).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionDate(Instant deletionDate);
    }

    private static final class BuilderImpl implements Builder {
        private String keyId;

        private Instant deletionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleKeyDeletionResponse model) {
            setKeyId(model.keyId);
            setDeletionDate(model.deletionDate);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Instant getDeletionDate() {
            return deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        @Override
        public ScheduleKeyDeletionResponse build() {
            return new ScheduleKeyDeletionResponse(this);
        }
    }
}
